/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import org.cyclops.energeticsheep.RegistryEntries;
import org.cyclops.energeticsheep.entity.EntityAIEatGrassFast;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepConfigCommon;

public abstract class EntityEnergeticSheepCommon
extends Sheep {
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_WHITE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/white"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_ORANGE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/orange"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_MAGENTA = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/magenta"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_LIGHT_BLUE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/light_blue"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_YELLOW = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/yellow"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_LIME = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/lime"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_PINK = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/pink"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_GRAY = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/gray"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_LIGHT_GRAY = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/light_gray"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_CYAN = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/cyan"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_PURPLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/purple"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_BLUE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/blue"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_BROWN = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/brown"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_GREEN = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/green"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_RED = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/red"));
    public static final ResourceKey<LootTable> LOOTTABLE_SHEEP_BLACK = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"entities/energetic_sheep/black"));
    protected final Map<DyeColor, ItemLike> woolByColor;
    private static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.defineId(EntityEnergeticSheepCommon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean powerBreeding = false;

    public EntityEnergeticSheepCommon(EntityType<? extends EntityEnergeticSheepCommon> type, Level world) {
        super(type, world);
        this.xpReward = 10;
        this.woolByColor = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), p_203402_0_ -> {
            p_203402_0_.put(DyeColor.WHITE, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_WHITE.value());
            p_203402_0_.put(DyeColor.ORANGE, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_ORANGE.value());
            p_203402_0_.put(DyeColor.MAGENTA, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_MAGENTA.value());
            p_203402_0_.put(DyeColor.LIGHT_BLUE, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_LIGHT_BLUE.value());
            p_203402_0_.put(DyeColor.YELLOW, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_YELLOW.value());
            p_203402_0_.put(DyeColor.LIME, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_LIME.value());
            p_203402_0_.put(DyeColor.PINK, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_PINK.value());
            p_203402_0_.put(DyeColor.GRAY, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_GRAY.value());
            p_203402_0_.put(DyeColor.LIGHT_GRAY, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_LIGHT_GRAY.value());
            p_203402_0_.put(DyeColor.CYAN, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_CYAN.value());
            p_203402_0_.put(DyeColor.PURPLE, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_PURPLE.value());
            p_203402_0_.put(DyeColor.BLUE, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_BLUE.value());
            p_203402_0_.put(DyeColor.BROWN, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_BROWN.value());
            p_203402_0_.put(DyeColor.GREEN, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_GREEN.value());
            p_203402_0_.put(DyeColor.RED, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_RED.value());
            p_203402_0_.put(DyeColor.BLACK, (ItemLike)RegistryEntries.ITEM_ENERGETIC_WOOL_BLACK.value());
        });
    }

    public Map<DyeColor, ItemLike> getWoolByColor() {
        return this.woolByColor;
    }

    public static int getCapacity(DyeColor color) {
        return EntityEnergeticSheepCommon.getCapacity(color, EntityEnergeticSheepConfigCommon.sheepBaseCapacity);
    }

    public static int getCapacity(DyeColor color, int base) {
        return (int)((double)base * (1.0 + (double)(DyeColor.values().length - color.ordinal() - 1) * EntityEnergeticSheepConfigCommon.additionalCapacityColorFactor));
    }

    public static void onLightning(Sheep sheep) {
        EntityEnergeticSheepCommon energeticSheep = (EntityEnergeticSheepCommon)((EntityType)RegistryEntries.ENTITY_TYPE_ENERGETIC_SHEEP.value()).create(sheep.level(), EntitySpawnReason.CONVERSION);
        if (sheep.hasCustomName()) {
            energeticSheep.setCustomName(sheep.getCustomName());
        }
        energeticSheep.age = sheep.getAge();
        energeticSheep.setSheared(sheep.isSheared());
        energeticSheep.setFleeceColorInternal(sheep.getColor());
        energeticSheep.absSnapTo(sheep.getX(), sheep.getY(), sheep.getZ(), sheep.yRotO, sheep.xRotO);
        sheep.remove(Entity.RemovalReason.DISCARDED);
        sheep.level().addFreshEntity((Entity)energeticSheep);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.removeGoal((Goal)this.eatBlockGoal);
        this.eatBlockGoal = new EntityAIEatGrassFast(this);
        this.targetSelector.addGoal(5, (Goal)this.eatBlockGoal);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENERGY, (Object)0);
    }

    protected void updateEnergy(int energy) {
        this.entityData.set(ENERGY, (Object)energy);
        float ratio = (float)energy / (float)this.getCapacity();
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.23 * (double)(1.0f + ratio));
        if (energy == 0) {
            this.setSheared(true);
        } else if (this.isSheared()) {
            this.setSheared(false);
        }
    }

    public int getEnergyClient() {
        return (Integer)this.entityData.get(ENERGY);
    }

    public abstract int getCapacity();

    public void ate() {
        super.ate();
        this.restoreAllEnergy();
    }

    protected abstract void initializeEnergy(DyeColor var1);

    protected abstract void restoreAllEnergy();

    protected abstract void consumeAllEnergy();

    public void shear(ServerLevel level, SoundSource soundSource, ItemStack tool) {
        for (ItemStack item : this.onShearedInternal(null, null, null, null)) {
            ItemEntity itementity = this.spawnAtLocation(level, item);
            if (itementity == null) continue;
            itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    protected List<ItemStack> onShearedInternal(@Nullable Player player, ItemStack item, Level world, BlockPos pos) {
        this.setSheared(true);
        this.consumeAllEnergy();
        int i = 1 + this.random.nextInt(3);
        ArrayList ret = Lists.newArrayList();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(this.woolByColor.get(this.getColor())));
        }
        this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
        return ret;
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putBoolean("powerBreeding", this.powerBreeding);
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setFleeceColorInternal(DyeColor.byId((int)input.getByteOr("Color", (byte)0)));
        this.powerBreeding = input.getBooleanOr("powerBreeding", false);
    }

    public Sheep getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        int chance = this.powerBreeding ? EntityEnergeticSheepConfigCommon.babyChancePowerBreeding : EntityEnergeticSheepConfigCommon.babyChance;
        this.powerBreeding = false;
        if (chance > 0 && this.random.nextInt(chance) == 0) {
            EntityEnergeticSheepCommon child = (EntityEnergeticSheepCommon)((EntityType)RegistryEntries.ENTITY_TYPE_ENERGETIC_SHEEP.value()).create((Level)world, EntitySpawnReason.BREEDING);
            DyeColor color = this.getColor() == ((EntityEnergeticSheepCommon)ageable).getColor() ? this.getColor() : EntityEnergeticSheepCommon.getRandomColor(this.random);
            child.setFleeceColorInternal(color);
            return child;
        }
        return super.getBreedOffspring(world, ageable);
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 2.0f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
    }

    public Optional<ResourceKey<LootTable>> getLootTable() {
        if (this.isSheared()) {
            return EntityType.SHEEP.getDefaultLootTable();
        }
        switch (this.getColor()) {
            default: {
                return Optional.of(LOOTTABLE_SHEEP_WHITE);
            }
            case ORANGE: {
                return Optional.of(LOOTTABLE_SHEEP_ORANGE);
            }
            case MAGENTA: {
                return Optional.of(LOOTTABLE_SHEEP_MAGENTA);
            }
            case LIGHT_BLUE: {
                return Optional.of(LOOTTABLE_SHEEP_LIGHT_BLUE);
            }
            case YELLOW: {
                return Optional.of(LOOTTABLE_SHEEP_YELLOW);
            }
            case LIME: {
                return Optional.of(LOOTTABLE_SHEEP_LIME);
            }
            case PINK: {
                return Optional.of(LOOTTABLE_SHEEP_PINK);
            }
            case GRAY: {
                return Optional.of(LOOTTABLE_SHEEP_GRAY);
            }
            case LIGHT_GRAY: {
                return Optional.of(LOOTTABLE_SHEEP_LIGHT_GRAY);
            }
            case CYAN: {
                return Optional.of(LOOTTABLE_SHEEP_CYAN);
            }
            case PURPLE: {
                return Optional.of(LOOTTABLE_SHEEP_PURPLE);
            }
            case BLUE: {
                return Optional.of(LOOTTABLE_SHEEP_BLUE);
            }
            case BROWN: {
                return Optional.of(LOOTTABLE_SHEEP_BROWN);
            }
            case GREEN: {
                return Optional.of(LOOTTABLE_SHEEP_GREEN);
            }
            case RED: {
                return Optional.of(LOOTTABLE_SHEEP_RED);
            }
            case BLACK: 
        }
        return Optional.of(LOOTTABLE_SHEEP_BLACK);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, EntitySpawnReason reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData livingdata = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setFleeceColorInternal(EntityEnergeticSheepCommon.getRandomColor(this.random));
        return livingdata;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).getItem() instanceof DyeItem) {
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public void setColor(DyeColor color) {
    }

    protected void setFleeceColorInternal(DyeColor color) {
        super.setColor(color);
        this.initializeEnergy(color);
    }

    protected static DyeColor getRandomColor(RandomSource random) {
        return DyeColor.values()[random.nextInt(DyeColor.values().length)];
    }

    protected boolean isPowerBreedingItem(ItemStack stack) {
        for (String name : EntityEnergeticSheepConfigCommon.powerBreedingItems) {
            if (!BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return super.isFood(stack) || this.isPowerBreedingItem(stack);
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isPowerBreedingItem(stack)) {
            this.powerBreeding = true;
            if (!this.level().isClientSide()) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getX(), this.getY(), this.getZ(), 10, 0.5, 0.5, 0.5, 2.0);
            }
        }
        super.usePlayerItem(player, hand, stack);
    }
}

