/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheepCommon;
import org.jetbrains.annotations.Nullable;

public class EntityEnergeticSheepForge
extends EntityEnergeticSheepCommon {
    @javax.annotation.Nullable
    private IEnergyStorage energyStorage;

    public EntityEnergeticSheepForge(EntityType<? extends EntityEnergeticSheepCommon> type, Level world) {
        super(type, world);
    }

    @javax.annotation.Nullable
    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    protected void initializeEnergy(DyeColor color) {
        this.energyStorage = new EnergyStorage(EntityEnergeticSheepForge.getCapacity(color)){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int ret = super.receiveEnergy(maxReceive, simulate);
                if (!simulate) {
                    EntityEnergeticSheepForge.this.updateEnergy(this.energy);
                }
                return ret;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int ret = super.extractEnergy(maxExtract, simulate);
                if (!simulate) {
                    EntityEnergeticSheepForge.this.updateEnergy(this.energy);
                }
                return ret;
            }
        };
    }

    @Override
    public int getCapacity() {
        return this.energyStorage != null ? this.energyStorage.getMaxEnergyStored() : 0;
    }

    @Override
    protected void restoreAllEnergy() {
        if (this.energyStorage != null) {
            this.energyStorage.receiveEnergy(this.energyStorage.getMaxEnergyStored(), false);
        }
    }

    @Override
    protected void consumeAllEnergy() {
        if (this.energyStorage != null) {
            this.energyStorage.extractEnergy(this.energyStorage.getMaxEnergyStored(), false);
        }
    }

    public List<ItemStack> onSheared(@javax.annotation.Nullable Player player, ItemStack item, Level world, BlockPos pos, int fortune) {
        return this.onShearedInternal(player, item, world, pos);
    }

    @Override
    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        if (this.energyStorage != null) {
            output.putInt("energy", this.energyStorage.getEnergyStored());
        }
    }

    @Override
    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.energyStorage.receiveEnergy(((Integer)input.getInt("energy").orElseThrow()).intValue(), false);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, EntitySpawnReason reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData data = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.energyStorage.receiveEnergy(this.energyStorage.getMaxEnergyStored(), false);
        return data;
    }

    @javax.annotation.Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.ENERGY && this.energyStorage != null) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        return super.getCapability(capability, facing);
    }
}

