/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.entity.layers;

import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EnergySwirlLayer;
import net.minecraft.client.renderer.entity.state.SheepRenderState;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.energeticsheep.client.render.entity.state.EntityRenderStateEnergeticSheep;

public class LayerEnergeticSheepCharge
extends EnergySwirlLayer<SheepRenderState, SheepModel> {
    public static ModelLayerLocation MODEL_LAYER_FUR_SCALED = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"energeticsheep", (String)"sheep"), "fur");
    private static final ResourceLocation CHARGE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/creeper/creeper_armor.png");
    private final SheepModel sheepModel;

    public LayerEnergeticSheepCharge(RenderLayerParent<SheepRenderState, SheepModel> renderer, EntityModelSet entityModelSet) {
        super(renderer);
        this.sheepModel = new SheepModel(entityModelSet.bakeLayer(MODEL_LAYER_FUR_SCALED));
    }

    public static LayerDefinition createFurLayer(float scale) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.6f * scale)), PartPose.offset((float)0.0f, (float)6.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-4.0f, -10.0f, -7.0f, 8.0f, 16.0f, 6.0f, new CubeDeformation(1.75f * scale)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f * scale));
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset((float)-3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset((float)3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset((float)-3.0f, (float)12.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset((float)3.0f, (float)12.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected boolean isPowered(SheepRenderState renderStateEnergeticSheep) {
        return ((EntityRenderStateEnergeticSheep)renderStateEnergeticSheep).isPowered;
    }

    protected float xOffset(float v) {
        return v * 0.01f;
    }

    protected ResourceLocation getTextureLocation() {
        return CHARGE_TEXTURE;
    }

    protected SheepModel model() {
        return this.sheepModel;
    }
}

