/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.item;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class ComponentEnergyStorage
implements IEnergyStorage {
    protected final ItemStack parent;
    protected final DataComponentType<Integer> energyComponent;
    protected final int capacity;
    protected final int maxReceive;
    protected final int maxExtract;

    public ComponentEnergyStorage(ItemStack parent, DataComponentType<Integer> energyComponent, int capacity, int maxReceive, int maxExtract) {
        this.parent = parent;
        this.energyComponent = energyComponent;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public ComponentEnergyStorage(ItemStack parent, DataComponentType<Integer> energyComponent, int capacity, int maxTransfer) {
        this(parent, energyComponent, capacity, maxTransfer, maxTransfer);
    }

    public ComponentEnergyStorage(ItemStack parent, DataComponentType<Integer> energyComponent, int capacity) {
        this(parent, energyComponent, capacity, capacity);
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        if (!this.canReceive() || toReceive <= 0) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int energyReceived = Mth.clamp((int)(this.capacity - energy), (int)0, (int)Math.min(this.maxReceive, toReceive));
        if (!simulate && energyReceived > 0) {
            this.setEnergy(energy + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (!this.canExtract() || toExtract <= 0) {
            return 0;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, toExtract));
        if (!simulate && energyExtracted > 0) {
            this.setEnergy(energy - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        int rawEnergy = (Integer)this.parent.getOrDefault(this.energyComponent, (Object)0);
        return Mth.clamp((int)rawEnergy, (int)0, (int)this.capacity);
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    protected void setEnergy(int energy) {
        int realEnergy = Mth.clamp((int)energy, (int)0, (int)this.capacity);
        this.parent.set(this.energyComponent, (Object)realEnergy);
    }
}

