/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.entity;

import com.github.iunius118.chilibulletweapons.advancements.ModCriteriaTriggers;
import com.github.iunius118.chilibulletweapons.entity.ModEntityTypes;
import com.github.iunius118.chilibulletweapons.item.ChiliBulletGunHelper;
import com.github.iunius118.chilibulletweapons.platform.Services;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class ChiliBullet
extends class_1682 {
    public static final String TAG_AGE = "Age";
    public static final String TAG_PIERCE_LEVEL = "PierceLevel";
    private static final class_2940<Byte> PIERCE_LEVEL = class_2945.method_12791(ChiliBullet.class, (class_2941)class_2943.field_13319);
    private double baseDamage;
    private byte age = 0;
    private IntOpenHashSet piercingIgnoreEntityIds;
    private int piercedAndKilledEntities = 0;

    public ChiliBullet(class_1299<ChiliBullet> entityType, class_1937 level) {
        super(entityType, level);
        this.setBaseDamage(Services.CONFIG.getChiliBulletBaseDamage());
    }

    public ChiliBullet(class_1937 level, double x, double y, double z, class_1799 weapon) {
        this(ModEntityTypes.CHILI_BULLET, level);
        int pierceLaval;
        this.method_5814(x, y, z);
        if (weapon != null && !weapon.method_7960() && !level.field_9236 && (pierceLaval = ChiliBulletGunHelper.getPiercing(weapon)) > 0) {
            this.setPierceLevel((byte)pierceLaval);
        }
    }

    public ChiliBullet(class_1937 level, class_1309 thrower, class_1799 weapon) {
        this(level, thrower.method_23317(), thrower.method_23320() - (double)0.05f, thrower.method_23321(), weapon);
        this.method_7432((class_1297)thrower);
    }

    public boolean method_5640(double distance) {
        double renderDistance = this.method_5829().method_995() * 10.0;
        if (Double.isNaN(renderDistance)) {
            renderDistance = 1.0;
        }
        return distance < (renderDistance *= 64.0 * ChiliBullet.method_5824()) * renderDistance;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(PIERCE_LEVEL, (Object)0);
    }

    public void method_5773() {
        Services.PLATFORM.tickProjectile(this);
        this.method_5670();
        class_243 startVec = this.method_19538();
        class_243 delta = this.method_18798();
        class_243 endVec = startVec.method_1019(delta);
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startVec, endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            endVec = hitResult.method_17784();
        }
        while (!this.method_31481()) {
            class_3966 entityHitResult1;
            class_1297 entity;
            class_3966 entityHitResult = this.findHitEntity(startVec, endVec);
            if (entityHitResult != null) {
                hitResult = entityHitResult;
            }
            if (hitResult instanceof class_3966 && (entity = (entityHitResult1 = (class_3966)hitResult).method_17782()) instanceof class_1657) {
                class_1657 owner;
                class_1657 player = (class_1657)entity;
                class_1297 class_12972 = this.method_24921();
                if (class_12972 instanceof class_1657 && !(owner = (class_1657)class_12972).method_7256(player)) {
                    hitResult = null;
                    entityHitResult = null;
                }
            }
            if (hitResult != null && hitResult.method_17783() != class_239.class_240.field_1333) {
                this.method_7488((class_239)hitResult);
                this.field_6007 = true;
            }
            if (entityHitResult == null || this.getPierceLevel() <= 0) break;
            hitResult = null;
        }
        if (this.method_31481()) {
            return;
        }
        this.method_5852();
        class_243 next = startVec.method_1019(delta);
        this.method_26962();
        float decelerationRatio = 0.99f;
        if (this.method_5799()) {
            for (int i = 0; i < 4; ++i) {
                float offset = 0.25f;
                this.method_37908().method_8406((class_2394)class_2398.field_11247, next.field_1352 - delta.field_1352 * (double)offset, next.field_1351 - delta.field_1351 * (double)offset, next.field_1350 - delta.field_1350 * (double)offset, delta.field_1352, delta.field_1351, delta.field_1350);
            }
            decelerationRatio = 0.8f;
        }
        this.method_18799(delta.method_1021((double)decelerationRatio));
        this.method_56990();
        this.method_33574(next);
        this.tickDespawn();
    }

    protected void tickDespawn() {
        this.age = (byte)(this.age + 1);
        if (this.age >= 40) {
            this.method_31472();
        }
    }

    protected double method_7490() {
        return 0.03f;
    }

    protected class_3966 findHitEntity(class_243 startVec, class_243 endVec) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)startVec, (class_243)endVec, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958);
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entity.method_5628()));
    }

    protected void method_7454(class_3966 result) {
        class_1282 damageSource;
        super.method_7454(result);
        class_1297 entity = result.method_17782();
        class_1297 owner = this.method_24921();
        byte pierceLevel = this.getPierceLevel();
        if (pierceLevel > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet((int)pierceLevel);
            }
            if (this.piercingIgnoreEntityIds.size() >= pierceLevel + 1) {
                this.method_31472();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.method_5628());
        }
        if (owner instanceof class_1309) {
            class_1309 livingEntity = (class_1309)owner;
            livingEntity.method_6114(entity);
        }
        if (!this.method_37908().field_9236 && Services.CONFIG.canMultishotMultiHit()) {
            entity.field_6008 = 0;
        }
        if (entity.method_5643(damageSource = this.method_48923().method_48811((class_1297)this, (class_1297)(owner != null ? owner : this)), (float)this.getDamage())) {
            if (entity != owner && entity instanceof class_1657 && owner instanceof class_3222) {
                class_3222 ownerInServer = (class_3222)owner;
                if (!this.method_5701()) {
                    ownerInServer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                }
            }
            if (!entity.method_5805()) {
                ++this.piercedAndKilledEntities;
            }
            if (!this.method_37908().field_9236 && owner instanceof class_3222) {
                class_3222 serverplayer = (class_3222)owner;
                if (this.piercedAndKilledEntities > 0) {
                    ModCriteriaTriggers.KILLED_BY_CHILI_BULLET.trigger(serverplayer, this.piercedAndKilledEntities);
                }
            }
        }
        if (pierceLevel <= 0) {
            this.method_31472();
        }
    }

    public byte getPierceLevel() {
        return (Byte)this.field_6011.method_12789(PIERCE_LEVEL);
    }

    public void setPierceLevel(byte level) {
        this.field_6011.method_12778(PIERCE_LEVEL, (Object)level);
    }

    private int getDamage() {
        if (this.baseDamage <= 0.0) {
            return 0;
        }
        double speedSqr = this.method_18798().method_1027();
        int force = class_3532.method_15384((double)class_3532.method_15350((double)(speedSqr * this.baseDamage), (double)0.0, (double)2.147483647E9));
        long randomDamage = this.field_5974.method_43048(force / 2 + 2);
        int damage = (int)Math.min((long)force + randomDamage, Integer.MAX_VALUE);
        boolean hasCritOccurred = this.field_5974.method_43057() < 0.1f;
        damage = hasCritOccurred ? Math.max(this.getCritDamage(), damage) : damage;
        return damage;
    }

    private int getCritDamage() {
        if (this.baseDamage <= 0.0) {
            return 0;
        }
        long critForce = class_3532.method_15384((double)class_3532.method_15350((double)(16.0 * this.baseDamage), (double)0.0, (double)2.147483647E9));
        return (int)Math.min(critForce + critForce / 2L + 1L, Integer.MAX_VALUE);
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(double damage) {
        this.baseDamage = damage;
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
        this.setPierceLevel((byte)0);
        this.method_31472();
    }

    public byte getAge() {
        return this.age;
    }

    public void setAge(byte age) {
        this.age = age;
    }

    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10567(TAG_AGE, this.age);
        compound.method_10567(TAG_PIERCE_LEVEL, this.getPierceLevel());
    }

    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setAge(compound.method_10571(TAG_AGE));
        this.setPierceLevel(compound.method_10571(TAG_PIERCE_LEVEL));
    }
}

