/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.item;

import com.github.iunius118.chilibulletweapons.component.GunContents;
import com.github.iunius118.chilibulletweapons.component.ModDataComponents;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import com.github.iunius118.chilibulletweapons.item.UpgradeGunPartItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3902;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9278;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class ChiliBulletGunHelper {
    public static boolean isLoaded(class_1799 stack) {
        return ChiliBulletGunHelper.isLoaded((class_9278)stack.method_57824(class_9334.field_49649));
    }

    public static boolean isLoaded(class_9278 chargedProjectiles) {
        return chargedProjectiles != null && !chargedProjectiles.method_57442();
    }

    public static boolean isLoading(class_1799 stack) {
        return stack.method_57826(ModDataComponents.LOADING);
    }

    public static void changeLoading(class_1799 stack, boolean isLoading) {
        if (stack.method_57826(ModDataComponents.LOADING)) {
            if (!isLoading) {
                stack.method_57381(ModDataComponents.LOADING);
            }
        } else if (isLoading) {
            stack.method_57379(ModDataComponents.LOADING, (Object)class_3902.field_17274);
        }
    }

    public static int getQuickLoading(class_1799 stack) {
        return GunContents.getQuickLoading(stack);
    }

    public static int getPiercing(class_1799 stack) {
        return GunContents.getPiercing(stack);
    }

    public static int getBarrelCount(class_1799 stack) {
        return GunContents.getBarrelCount(stack);
    }

    public static boolean canMultishot(class_1799 stack) {
        return ChiliBulletGunHelper.getBarrelCount(stack) > 1;
    }

    public static boolean isBayoneted(class_1799 stack) {
        return stack.method_57826(ModDataComponents.BAYONETED);
    }

    public static float getShootingPower(int piercing) {
        if (piercing < 1) {
            return 3.0f;
        }
        return 4.0f;
    }

    public static float getShootingPower(class_1799 stack) {
        return ChiliBulletGunHelper.getShootingPower(ChiliBulletGunHelper.getPiercing(stack));
    }

    public static float getInaccuracy(class_1799 stack) {
        if (ChiliBulletGunHelper.getPiercing(stack) < 1) {
            return 1.0f;
        }
        return 0.5f;
    }

    public static int getReloadDuration(class_1799 stack) {
        int quickLoading;
        int basicDuration = 14;
        if (ChiliBulletGunHelper.getBarrelCount(stack) > 1) {
            basicDuration = 22;
        }
        if (stack.method_57826(ModDataComponents.BAYONETED)) {
            basicDuration += 2;
        }
        if ((quickLoading = ChiliBulletGunHelper.getQuickLoading(stack)) == 0) {
            return basicDuration;
        }
        return Math.max(0, basicDuration - 2 * quickLoading);
    }

    public static void setItemAttributeModifiers(class_1799 stack, float attackDamage, float attackSpeed) {
        class_9285 itemAttributeModifiers = class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(class_1792.field_8006, (double)attackDamage, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(class_1792.field_8001, (double)attackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486();
        stack.method_57379(class_9334.field_49636, (Object)itemAttributeModifiers);
    }

    public static List<class_1799> getCreativeGuns() {
        if (ModItems.GUN == null) {
            return List.of();
        }
        ArrayList<class_1799> guns = new ArrayList<class_1799>();
        class_1799 gun = new class_1799((class_1935)ModItems.GUN);
        guns.add(gun);
        if (ModItems.UPGRADE_GUN_BARREL == null || ModItems.UPGRADE_GUN_BAYONET == null) {
            return guns;
        }
        UpgradeGunPartItem upgradeGunBarrel = (UpgradeGunPartItem)ModItems.UPGRADE_GUN_BARREL;
        UpgradeGunPartItem upgradeGunBayonet = (UpgradeGunPartItem)ModItems.UPGRADE_GUN_BAYONET;
        class_1799 rifle = upgradeGunBarrel.upgrade(gun);
        class_1799 volleyGun = upgradeGunBarrel.upgrade(rifle);
        guns.add(rifle);
        guns.add(volleyGun);
        guns.add(upgradeGunBayonet.upgrade(gun));
        guns.add(upgradeGunBayonet.upgrade(rifle));
        guns.add(upgradeGunBayonet.upgrade(volleyGun));
        return guns;
    }

    private ChiliBulletGunHelper() {
    }
}

