/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.item;

import com.github.iunius118.chilibulletweapons.advancements.ModCriteriaTriggers;
import com.github.iunius118.chilibulletweapons.component.DyedGunColors;
import com.github.iunius118.chilibulletweapons.component.GunContents;
import com.github.iunius118.chilibulletweapons.component.ModDataComponents;
import com.github.iunius118.chilibulletweapons.entity.ChiliBullet;
import com.github.iunius118.chilibulletweapons.item.ChiliBulletGunHelper;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import com.github.iunius118.chilibulletweapons.sounds.ModSoundEvents;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5819;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class ChiliBulletGunItem
extends class_1764 {
    public static final Predicate<class_1799> IS_CHILI_BULLET = itemStack -> itemStack.method_31574(ModItems.CHILI_BULLET);

    public ChiliBulletGunItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7860(class_1799 stack) {
        super.method_7860(stack);
        this.applyBayonetAttackDamage(stack);
    }

    public void applyBayonetAttackDamage(class_1799 stack) {
        Float bayonetAttackDamage = (Float)stack.method_57824(ModDataComponents.BAYONETED);
        if (bayonetAttackDamage != null) {
            ChiliBulletGunHelper.setItemAttributeModifiers(stack, bayonetAttackDamage.floatValue(), -2.8f);
        }
    }

    public Predicate<class_1799> method_20310() {
        return this.method_19268();
    }

    public Predicate<class_1799> method_19268() {
        return IS_CHILI_BULLET;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (ChiliBulletGunHelper.isLoaded(itemStack) && !ChiliBulletGunHelper.isLoading(itemStack)) {
            this.method_7777(level, (class_1309)player, hand, itemStack, ChiliBulletGunHelper.getShootingPower(itemStack), ChiliBulletGunHelper.getInaccuracy(itemStack), null);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!player.method_18808(itemStack).method_7960()) {
            if (!ChiliBulletGunHelper.isLoading(itemStack)) {
                this.openAction(level, (class_1309)player, itemStack);
            }
            player.method_6019(hand);
            return class_1271.method_22428((Object)itemStack);
        }
        if (ChiliBulletGunHelper.isLoading(itemStack)) {
            this.closeAction(level, (class_1309)player, itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7777(class_1937 level, class_1309 shooter, class_1268 hand, class_1799 weapon, float velocity, float inaccuracy, class_1309 target) {
        if (level instanceof class_3218) {
            class_3218 serverlevel = (class_3218)level;
            class_9278 chargedprojectiles = (class_9278)weapon.method_57379(class_9334.field_49649, (Object)class_9278.field_49298);
            if (chargedprojectiles != null && !chargedprojectiles.method_57442()) {
                this.method_57393(serverlevel, shooter, hand, weapon, chargedprojectiles.method_57437(), velocity, inaccuracy, false, target);
                if (shooter instanceof class_3222) {
                    class_3222 serverplayer = (class_3222)shooter;
                    ModCriteriaTriggers.SHOT_CHILI_BULLET_GUN.trigger(serverplayer, weapon);
                    serverplayer.method_7259(class_3468.field_15372.method_14956((Object)weapon.method_7909()));
                }
            }
        }
    }

    public void performShootingByNonPlayer(class_1937 level, class_1309 livingEntity, class_1268 hand, class_1799 stack) {
        this.method_7777(level, livingEntity, hand, stack, ChiliBulletGunHelper.getShootingPower(stack), ChiliBulletGunHelper.getInaccuracy(stack), null);
    }

    protected void method_57393(class_3218 level, class_1309 shooter, class_1268 hand, class_1799 weapon, List<class_1799> projectileItems, float velocity, float inaccuracy, boolean isCrit, class_1309 target) {
        int abrasion = 0;
        for (int i = 0; i < projectileItems.size(); ++i) {
            class_1799 projectileItem = projectileItems.get(i);
            if (projectileItem.method_7960()) continue;
            class_1676 projectile = this.method_57344((class_1937)level, shooter, weapon, projectileItem, isCrit);
            this.method_7763(shooter, projectile, i, velocity, inaccuracy, 0.0f, target);
            level.method_8649((class_1297)projectile);
            abrasion += this.method_57345(projectileItem);
        }
        this.hurtAndBreak(weapon, abrasion, shooter, class_1309.method_56079((class_1268)hand));
    }

    protected class_1676 method_57344(class_1937 level, class_1309 shooter, class_1799 weapon, class_1799 ammo, boolean isCrit) {
        return new ChiliBullet(level, shooter, weapon);
    }

    protected int method_57345(class_1799 stack) {
        return 1;
    }

    public void hurtAndBreak(class_1799 stack, int amount, class_1309 entityLiving, class_1304 slot) {
        if (stack.method_57826(class_9334.field_49631) && entityLiving.method_59922().method_43048(2) == 0) {
            return;
        }
        stack.method_7970(amount, entityLiving, slot);
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float velocity, float inaccuracy, float angle, class_1309 target) {
        float fixedInaccuracy = inaccuracy;
        if (index > 0) {
            fixedInaccuracy += 4.0f;
        }
        projectile.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, velocity, fixedInaccuracy);
        class_1937 level = shooter.method_37908();
        ChiliBulletGunItem.addSmokeParticle(level, projectile);
        level.method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), ModSoundEvents.GUN_SHOOT, shooter.method_5634(), 1.0f, ChiliBulletGunItem.getRandomPitch(shooter.method_59922()));
    }

    private static void addSmokeParticle(class_1937 level, class_1676 projectile) {
        class_243 pos = projectile.method_19538().method_1019(projectile.method_18798().method_1029());
        ((class_3218)level).method_14199((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, 0, 0.0, 0.0, 0.0, 2.0);
    }

    private static float getRandomPitch(class_5819 random) {
        return 1.0f / (random.method_43057() * 0.5f + 1.0f) + 0.2f;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entityLiving, int timeLeft) {
        if (stack.method_7935(entityLiving) - timeLeft >= this.getReloadDuration(stack) && !ChiliBulletGunHelper.isLoaded(stack)) {
            ChiliBulletGunHelper.changeLoading(stack, false);
        }
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 stack, int count) {
        int usingCount = stack.method_7935(livingEntity) - count;
        boolean isLoading = ChiliBulletGunHelper.isLoading(stack);
        if (usingCount == 0 && !isLoading) {
            this.openAction(level, livingEntity, stack);
        }
        if (level.field_9236) {
            return;
        }
        if (usingCount >= this.getReloadDuration(stack) && isLoading && ChiliBulletGunItem.tryLoadProjectiles(livingEntity, stack)) {
            this.closeAction(level, livingEntity, stack);
        }
    }

    private void openAction(class_1937 level, class_1309 livingEntity, class_1799 stack) {
        ChiliBulletGunHelper.changeLoading(stack, true);
        level.method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), ModSoundEvents.GUN_ACTION_OPEN, livingEntity.method_5634(), 1.0f, ChiliBulletGunItem.getRandomPitch(livingEntity.method_59922()));
    }

    private void closeAction(class_1937 level, class_1309 livingEntity, class_1799 stack) {
        ChiliBulletGunHelper.changeLoading(stack, false);
        level.method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), ModSoundEvents.GUN_ACTION_CLOSE, livingEntity.method_5634(), 1.0f, ChiliBulletGunItem.getRandomPitch(livingEntity.method_59922()));
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return this.getReloadDuration(stack) + 3;
    }

    public int getReloadDuration(class_1799 stack) {
        return ChiliBulletGunHelper.getReloadDuration(stack);
    }

    public static boolean tryLoadProjectiles(class_1309 shooter, class_1799 stack) {
        class_1799 ammo = shooter.method_18808(stack);
        ammo = ammo.method_31574(class_1802.field_8107) ? new class_1799((class_1935)ModItems.CHILI_BULLET) : ammo;
        List<class_1799> list = ChiliBulletGunItem.draw(stack, ammo, shooter);
        if (!list.isEmpty()) {
            stack.method_57379(class_9334.field_49649, (Object)class_9278.method_57441(list));
            return true;
        }
        return false;
    }

    protected static List<class_1799> draw(class_1799 weapon, class_1799 ammo, class_1309 shooter) {
        int barrelCount = ChiliBulletGunHelper.getBarrelCount(weapon);
        if (shooter.method_56992()) {
            class_1799 infAmmo = ammo.method_7960() ? new class_1799((class_1935)ModItems.CHILI_BULLET) : ammo.method_7972();
            return Stream.generate(() -> infAmmo.method_46651(1)).limit(barrelCount).toList();
        }
        if (ammo.method_7960()) {
            return List.of();
        }
        int ammoCount = Math.min(ammo.method_7947(), barrelCount);
        List<class_1799> list = Stream.generate(() -> ammo.method_7971(1)).limit(ammoCount).toList();
        if (ammo.method_7960() && shooter instanceof class_1657) {
            class_1657 player = (class_1657)shooter;
            player.method_31548().method_7378(ammo);
        }
        return list;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        return true;
    }

    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (stack.method_57826(ModDataComponents.BAYONETED)) {
            this.hurtAndBreak(stack, 1, attacker, class_1304.field_6173);
        }
    }

    public int method_24792() {
        return 15;
    }

    public int method_7837() {
        return 15;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        GunContents.getOrDefault(stack).addToTooltip(tooltipComponents, tooltipFlag);
        DyedGunColors dyedGunColors = (DyedGunColors)stack.method_57824(ModDataComponents.DYED_GUN_COLORS);
        if (dyedGunColors != null) {
            DyedGunColors.getOrDefault(stack).addToTooltip(tooltipComponents, tooltipFlag);
        }
    }

    public String method_7866(class_1799 stack) {
        boolean hasPiercing;
        boolean isBayoneted = stack.method_57826(ModDataComponents.BAYONETED);
        boolean canMultishot = ChiliBulletGunHelper.canMultishot(stack);
        boolean bl = hasPiercing = ChiliBulletGunHelper.getPiercing(stack) > 0;
        if (isBayoneted) {
            if (canMultishot) {
                return "item.chilibulletweapons.gun.bayoneted.volley_gun";
            }
            if (hasPiercing) {
                return "item.chilibulletweapons.gun.bayoneted.rifle";
            }
            return "item.chilibulletweapons.gun.bayoneted.pistol";
        }
        if (canMultishot) {
            return "item.chilibulletweapons.gun.volley_gun";
        }
        if (hasPiercing) {
            return "item.chilibulletweapons.gun.rifle";
        }
        return "item.chilibulletweapons.gun.pistol";
    }

    public boolean isUpgradable(class_1799 stack) {
        return !stack.method_57826(ModDataComponents.FIXED);
    }
}

