/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.entity;

import com.github.iunius118.chilibulletweapons.advancements.ModCriteriaTriggers;
import com.github.iunius118.chilibulletweapons.entity.ModEntityTypes;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import com.github.iunius118.chilibulletweapons.platform.Services;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ChiliArrow
extends AbstractArrow {
    public ChiliArrow(EntityType<? extends ChiliArrow> entityType, Level level) {
        super(entityType, level);
    }

    public ChiliArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, ItemStack firedFromWeapon) {
        super(ModEntityTypes.CHILI_ARROW, x, y, z, level, pickupItemStack, firedFromWeapon);
    }

    public ChiliArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, ItemStack firedFromWeapon) {
        super(ModEntityTypes.CHILI_ARROW, owner, level, pickupItemStack, firedFromWeapon);
    }

    public void tick() {
        super.tick();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.CHILI_ARROW);
    }

    protected void onHitBlock(BlockHitResult result) {
        if (this.getDeltaMovement().length() < 0.8) {
            super.onHitBlock(result);
            return;
        }
        Level level = this.level();
        BlockState blockState = level.getBlockState(result.getBlockPos());
        blockState.onProjectileHit(level, blockState, result, (Projectile)this);
        this.inGround = true;
        this.discard();
        if (!level.isClientSide) {
            this.explode(level, result.getLocation(), this.getExplosivePower((Entity)this));
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.getDeltaMovement().length() < 0.8) {
            super.onHitEntity(result);
            return;
        }
        Level level = this.level();
        this.discard();
        if (!level.isClientSide) {
            this.explode(level, result.getLocation(), this.getExplosivePower(result.getEntity()));
        }
    }

    private void explode(Level level, Vec3 pos, float power) {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer shooter = (ServerPlayer)entity;
            ModCriteriaTriggers.EXPLODED_CHILI_ARROW.trigger(shooter);
        }
        level.explode((Entity)this, pos.x, pos.y, pos.z, power, Level.ExplosionInteraction.NONE);
    }

    private float getExplosivePower(Entity entity) {
        ServerLevel serverlevel;
        Level level;
        Entity owner = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)(owner != null ? owner : this));
        float damage = (float)this.getBaseDamage();
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel && (double)(damage = EnchantmentHelper.modifyDamage((ServerLevel)(serverlevel = (ServerLevel)level), (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)damage)) > this.getBaseDamage()) {
            damage += 0.5f;
        }
        float damageMultiplier = Services.CONFIG.getChiliArrowDamageMultiplier();
        return (damage / 5.0f + 0.6f) * damageMultiplier;
    }
}

