/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.entity;

import com.github.iunius118.chilibulletweapons.advancements.ModCriteriaTriggers;
import com.github.iunius118.chilibulletweapons.entity.ModEntityTypes;
import com.github.iunius118.chilibulletweapons.item.ChiliBulletGunHelper;
import com.github.iunius118.chilibulletweapons.platform.Services;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ChiliBullet
extends ThrowableProjectile {
    public static final String TAG_AGE = "Age";
    public static final String TAG_PIERCE_LEVEL = "PierceLevel";
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.defineId(ChiliBullet.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private double baseDamage;
    private byte age = 0;
    private IntOpenHashSet piercingIgnoreEntityIds;
    private int piercedAndKilledEntities = 0;

    public ChiliBullet(EntityType<ChiliBullet> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(Services.CONFIG.getChiliBulletBaseDamage());
    }

    public ChiliBullet(Level level, double x, double y, double z, ItemStack weapon) {
        this(ModEntityTypes.CHILI_BULLET, level);
        int pierceLaval;
        this.setPos(x, y, z);
        if (weapon != null && !weapon.isEmpty() && !level.isClientSide && (pierceLaval = ChiliBulletGunHelper.getPiercing(weapon)) > 0) {
            this.setPierceLevel((byte)pierceLaval);
        }
    }

    public ChiliBullet(Level level, LivingEntity thrower, ItemStack weapon) {
        this(level, thrower.getX(), thrower.getEyeY() - (double)0.05f, thrower.getZ(), weapon);
        this.setOwner((Entity)thrower);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double renderDistance = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(renderDistance)) {
            renderDistance = 1.0;
        }
        return distance < (renderDistance *= 64.0 * ChiliBullet.getViewScale()) * renderDistance;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PIERCE_LEVEL, (Object)0);
    }

    public void tick() {
        Services.PLATFORM.tickProjectile(this);
        this.baseTick();
        Vec3 startVec = this.position();
        Vec3 delta = this.getDeltaMovement();
        Vec3 endVec = startVec.add(delta);
        BlockHitResult hitResult = this.level().clip(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult.getType() != HitResult.Type.MISS) {
            endVec = hitResult.getLocation();
        }
        while (!this.isRemoved()) {
            EntityHitResult entityHitResult1;
            Entity entity;
            EntityHitResult entityHitResult = this.findHitEntity(startVec, endVec);
            if (entityHitResult != null) {
                hitResult = entityHitResult;
            }
            if (hitResult instanceof EntityHitResult && (entity = (entityHitResult1 = (EntityHitResult)hitResult).getEntity()) instanceof Player) {
                Player owner;
                Player player = (Player)entity;
                Entity entity2 = this.getOwner();
                if (entity2 instanceof Player && !(owner = (Player)entity2).canHarmPlayer(player)) {
                    hitResult = null;
                    entityHitResult = null;
                }
            }
            if (hitResult != null && hitResult.getType() != HitResult.Type.MISS) {
                this.onHit((HitResult)hitResult);
                this.hasImpulse = true;
            }
            if (entityHitResult == null || this.getPierceLevel() <= 0) break;
            hitResult = null;
        }
        if (this.isRemoved()) {
            return;
        }
        this.checkInsideBlocks();
        Vec3 next = startVec.add(delta);
        this.updateRotation();
        float decelerationRatio = 0.99f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float offset = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, next.x - delta.x * (double)offset, next.y - delta.y * (double)offset, next.z - delta.z * (double)offset, delta.x, delta.y, delta.z);
            }
            decelerationRatio = 0.8f;
        }
        this.setDeltaMovement(delta.scale((double)decelerationRatio));
        this.applyGravity();
        this.setPos(next);
        this.tickDespawn();
    }

    protected void tickDespawn() {
        this.age = (byte)(this.age + 1);
        if (this.age >= 40) {
            this.discard();
        }
    }

    protected double getDefaultGravity() {
        return 0.03f;
    }

    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entity.getId()));
    }

    protected void onHitEntity(EntityHitResult result) {
        DamageSource damageSource;
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        Entity owner = this.getOwner();
        byte pierceLevel = this.getPierceLevel();
        if (pierceLevel > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet((int)pierceLevel);
            }
            if (this.piercingIgnoreEntityIds.size() >= pierceLevel + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            livingEntity.setLastHurtMob(entity);
        }
        if (!this.level().isClientSide && Services.CONFIG.canMultishotMultiHit()) {
            entity.invulnerableTime = 0;
        }
        if (entity.hurt(damageSource = this.damageSources().thrown((Entity)this, (Entity)(owner != null ? owner : this)), (float)this.getDamage())) {
            if (entity != owner && entity instanceof Player && owner instanceof ServerPlayer) {
                ServerPlayer ownerInServer = (ServerPlayer)owner;
                if (!this.isSilent()) {
                    ownerInServer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
            if (!entity.isAlive()) {
                ++this.piercedAndKilledEntities;
            }
            if (!this.level().isClientSide && owner instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)owner;
                if (this.piercedAndKilledEntities > 0) {
                    ModCriteriaTriggers.KILLED_BY_CHILI_BULLET.trigger(serverplayer, this.piercedAndKilledEntities);
                }
            }
        }
        if (pierceLevel <= 0) {
            this.discard();
        }
    }

    public byte getPierceLevel() {
        return (Byte)this.entityData.get(PIERCE_LEVEL);
    }

    public void setPierceLevel(byte level) {
        this.entityData.set(PIERCE_LEVEL, (Object)level);
    }

    private int getDamage() {
        if (this.baseDamage <= 0.0) {
            return 0;
        }
        double speedSqr = this.getDeltaMovement().lengthSqr();
        int force = Mth.ceil((double)Mth.clamp((double)(speedSqr * this.baseDamage), (double)0.0, (double)2.147483647E9));
        long randomDamage = this.random.nextInt(force / 2 + 2);
        int damage = (int)Math.min((long)force + randomDamage, Integer.MAX_VALUE);
        boolean hasCritOccurred = this.random.nextFloat() < 0.1f;
        damage = hasCritOccurred ? Math.max(this.getCritDamage(), damage) : damage;
        return damage;
    }

    private int getCritDamage() {
        if (this.baseDamage <= 0.0) {
            return 0;
        }
        long critForce = Mth.ceil((double)Mth.clamp((double)(16.0 * this.baseDamage), (double)0.0, (double)2.147483647E9));
        return (int)Math.min(critForce + critForce / 2L + 1L, Integer.MAX_VALUE);
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(double damage) {
        this.baseDamage = damage;
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.setPierceLevel((byte)0);
        this.discard();
    }

    public byte getAge() {
        return this.age;
    }

    public void setAge(byte age) {
        this.age = age;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(TAG_AGE, this.age);
        compound.putByte(TAG_PIERCE_LEVEL, this.getPierceLevel());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setAge(compound.getByte(TAG_AGE));
        this.setPierceLevel(compound.getByte(TAG_PIERCE_LEVEL));
    }
}

