/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.item;

import com.github.iunius118.chilibulletweapons.advancements.ModCriteriaTriggers;
import com.github.iunius118.chilibulletweapons.component.DyedGunColors;
import com.github.iunius118.chilibulletweapons.component.GunContents;
import com.github.iunius118.chilibulletweapons.component.ModDataComponents;
import com.github.iunius118.chilibulletweapons.entity.ChiliBullet;
import com.github.iunius118.chilibulletweapons.item.ChiliBulletGunHelper;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import com.github.iunius118.chilibulletweapons.sounds.ModSoundEvents;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChiliBulletGunItem
extends CrossbowItem {
    public static final Predicate<ItemStack> IS_CHILI_BULLET = itemStack -> itemStack.is(ModItems.CHILI_BULLET);

    public ChiliBulletGunItem(Item.Properties properties) {
        super(properties);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        this.applyBayonetAttackDamage(stack);
    }

    public void applyBayonetAttackDamage(ItemStack stack) {
        Float bayonetAttackDamage = (Float)stack.get(ModDataComponents.BAYONETED);
        if (bayonetAttackDamage != null) {
            ChiliBulletGunHelper.setItemAttributeModifiers(stack, bayonetAttackDamage.floatValue(), -2.8f);
        }
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return IS_CHILI_BULLET;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (ChiliBulletGunHelper.isLoaded(itemStack) && !ChiliBulletGunHelper.isLoading(itemStack)) {
            this.performShooting(level, (LivingEntity)player, hand, itemStack, ChiliBulletGunHelper.getShootingPower(itemStack), ChiliBulletGunHelper.getInaccuracy(itemStack), null);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        if (!player.getProjectile(itemStack).isEmpty()) {
            if (!ChiliBulletGunHelper.isLoading(itemStack)) {
                this.openAction(level, (LivingEntity)player, itemStack);
            }
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        if (ChiliBulletGunHelper.isLoading(itemStack)) {
            this.closeAction(level, (LivingEntity)player, itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void performShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, float velocity, float inaccuracy, LivingEntity target) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            ChargedProjectiles chargedprojectiles = (ChargedProjectiles)weapon.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            if (chargedprojectiles != null && !chargedprojectiles.isEmpty()) {
                this.shoot(serverlevel, shooter, hand, weapon, chargedprojectiles.getItems(), velocity, inaccuracy, false, target);
                if (shooter instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)shooter;
                    ModCriteriaTriggers.SHOT_CHILI_BULLET_GUN.trigger(serverplayer, weapon);
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
                }
            }
        }
    }

    public void performShootingByNonPlayer(Level level, LivingEntity livingEntity, InteractionHand hand, ItemStack stack) {
        this.performShooting(level, livingEntity, hand, stack, ChiliBulletGunHelper.getShootingPower(stack), ChiliBulletGunHelper.getInaccuracy(stack), null);
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, LivingEntity target) {
        int abrasion = 0;
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack projectileItem = projectileItems.get(i);
            if (projectileItem.isEmpty()) continue;
            Projectile projectile = this.createProjectile((Level)level, shooter, weapon, projectileItem, isCrit);
            this.shootProjectile(shooter, projectile, i, velocity, inaccuracy, 0.0f, target);
            level.addFreshEntity((Entity)projectile);
            abrasion += this.getDurabilityUse(projectileItem);
        }
        this.hurtAndBreak(weapon, abrasion, shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        return new ChiliBullet(level, shooter, weapon);
    }

    protected int getDurabilityUse(ItemStack stack) {
        return 1;
    }

    public void hurtAndBreak(ItemStack stack, int amount, LivingEntity entityLiving, EquipmentSlot slot) {
        if (stack.has(DataComponents.CUSTOM_NAME) && entityLiving.getRandom().nextInt(2) == 0) {
            return;
        }
        stack.hurtAndBreak(amount, entityLiving, slot);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, LivingEntity target) {
        float fixedInaccuracy = inaccuracy;
        if (index > 0) {
            fixedInaccuracy += 4.0f;
        }
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, velocity, fixedInaccuracy);
        Level level = shooter.level();
        ChiliBulletGunItem.addSmokeParticle(level, projectile);
        level.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), ModSoundEvents.GUN_SHOOT, shooter.getSoundSource(), 1.0f, ChiliBulletGunItem.getRandomPitch(shooter.getRandom()));
    }

    private static void addSmokeParticle(Level level, Projectile projectile) {
        Vec3 pos = projectile.position().add(projectile.getDeltaMovement().normalize());
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0, 0.0, 0.0, 0.0, 2.0);
    }

    private static float getRandomPitch(RandomSource random) {
        return 1.0f / (random.nextFloat() * 0.5f + 1.0f) + 0.2f;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (stack.getUseDuration(entityLiving) - timeLeft >= this.getReloadDuration(stack) && !ChiliBulletGunHelper.isLoaded(stack)) {
            ChiliBulletGunHelper.changeLoading(stack, false);
        }
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int count) {
        int usingCount = stack.getUseDuration(livingEntity) - count;
        boolean isLoading = ChiliBulletGunHelper.isLoading(stack);
        if (usingCount == 0 && !isLoading) {
            this.openAction(level, livingEntity, stack);
        }
        if (level.isClientSide) {
            return;
        }
        if (usingCount >= this.getReloadDuration(stack) && isLoading && ChiliBulletGunItem.tryLoadProjectiles(livingEntity, stack)) {
            this.closeAction(level, livingEntity, stack);
        }
    }

    private void openAction(Level level, LivingEntity livingEntity, ItemStack stack) {
        ChiliBulletGunHelper.changeLoading(stack, true);
        level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), ModSoundEvents.GUN_ACTION_OPEN, livingEntity.getSoundSource(), 1.0f, ChiliBulletGunItem.getRandomPitch(livingEntity.getRandom()));
    }

    private void closeAction(Level level, LivingEntity livingEntity, ItemStack stack) {
        ChiliBulletGunHelper.changeLoading(stack, false);
        level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), ModSoundEvents.GUN_ACTION_CLOSE, livingEntity.getSoundSource(), 1.0f, ChiliBulletGunItem.getRandomPitch(livingEntity.getRandom()));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.getReloadDuration(stack) + 3;
    }

    public int getReloadDuration(ItemStack stack) {
        return ChiliBulletGunHelper.getReloadDuration(stack);
    }

    public static boolean tryLoadProjectiles(LivingEntity shooter, ItemStack stack) {
        ItemStack ammo = shooter.getProjectile(stack);
        ammo = ammo.is(Items.ARROW) ? new ItemStack((ItemLike)ModItems.CHILI_BULLET) : ammo;
        List<ItemStack> list = ChiliBulletGunItem.draw(stack, ammo, shooter);
        if (!list.isEmpty()) {
            stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(list));
            return true;
        }
        return false;
    }

    protected static List<ItemStack> draw(ItemStack weapon, ItemStack ammo, LivingEntity shooter) {
        int barrelCount = ChiliBulletGunHelper.getBarrelCount(weapon);
        if (shooter.hasInfiniteMaterials()) {
            ItemStack infAmmo = ammo.isEmpty() ? new ItemStack((ItemLike)ModItems.CHILI_BULLET) : ammo.copy();
            return Stream.generate(() -> infAmmo.copyWithCount(1)).limit(barrelCount).toList();
        }
        if (ammo.isEmpty()) {
            return List.of();
        }
        int ammoCount = Math.min(ammo.getCount(), barrelCount);
        List<ItemStack> list = Stream.generate(() -> ammo.split(1)).limit(ammoCount).toList();
        if (ammo.isEmpty() && shooter instanceof Player) {
            Player player = (Player)shooter;
            player.getInventory().removeItem(ammo);
        }
        return list;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (stack.has(ModDataComponents.BAYONETED)) {
            this.hurtAndBreak(stack, 1, attacker, EquipmentSlot.MAINHAND);
        }
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        GunContents.getOrDefault(stack).addToTooltip(tooltipComponents, tooltipFlag);
        DyedGunColors dyedGunColors = (DyedGunColors)stack.get(ModDataComponents.DYED_GUN_COLORS);
        if (dyedGunColors != null) {
            DyedGunColors.getOrDefault(stack).addToTooltip(tooltipComponents, tooltipFlag);
        }
    }

    public String getDescriptionId(ItemStack stack) {
        boolean hasPiercing;
        boolean isBayoneted = stack.has(ModDataComponents.BAYONETED);
        boolean canMultishot = ChiliBulletGunHelper.canMultishot(stack);
        boolean bl = hasPiercing = ChiliBulletGunHelper.getPiercing(stack) > 0;
        if (isBayoneted) {
            if (canMultishot) {
                return "item.chilibulletweapons.gun.bayoneted.volley_gun";
            }
            if (hasPiercing) {
                return "item.chilibulletweapons.gun.bayoneted.rifle";
            }
            return "item.chilibulletweapons.gun.bayoneted.pistol";
        }
        if (canMultishot) {
            return "item.chilibulletweapons.gun.volley_gun";
        }
        if (hasPiercing) {
            return "item.chilibulletweapons.gun.rifle";
        }
        return "item.chilibulletweapons.gun.pistol";
    }

    public boolean isUpgradable(ItemStack stack) {
        return !stack.has(ModDataComponents.FIXED);
    }
}

