/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.item;

import com.github.iunius118.chilibulletweapons.advancements.ModCriteriaTriggers;
import com.github.iunius118.chilibulletweapons.item.ChiliBulletGunItem;
import com.github.iunius118.chilibulletweapons.sounds.ModSoundEvents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class UpgradeGunPartItem
extends Item {
    public UpgradeGunPartItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canUpgrade(ItemStack stack) {
        ChiliBulletGunItem gun;
        Item item = stack.getItem();
        return item instanceof ChiliBulletGunItem && (gun = (ChiliBulletGunItem)item).isUpgradable(stack);
    }

    public abstract ItemStack upgrade(ItemStack var1);

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack usedStack = player.getItemInHand(hand);
        ItemStack offHandStack = player.getItemInHand(InteractionHand.OFF_HAND);
        if (hand != InteractionHand.MAIN_HAND || !this.canUpgrade(offHandStack)) {
            return InteractionResultHolder.pass((Object)usedStack);
        }
        if (!level.isClientSide()) {
            ItemStack upgradedGunStack = this.upgrade(offHandStack);
            player.setItemInHand(InteractionHand.OFF_HAND, upgradedGunStack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                ModCriteriaTriggers.UPGRADED_CHILI_BULLET_GUN.trigger(serverplayer, usedStack);
                serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (!player.getAbilities().instabuild) {
                usedStack.shrink(1);
            }
        }
        player.playSound(ModSoundEvents.GUN_UPGRADE, 0.5f, 1.1f + level.getRandom().nextFloat() * 0.1f);
        return InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.chilibulletweapons.upgrade_gun_1").withStyle(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.chilibulletweapons.upgrade_gun_2").withStyle(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.chilibulletweapons.upgrade_gun_3").withStyle(ChatFormatting.YELLOW));
    }
}

