/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons;

import com.github.iunius118.chilibulletweapons.ChiliBulletWeaponsClient;
import com.github.iunius118.chilibulletweapons.CommonClass;
import com.github.iunius118.chilibulletweapons.data.ModAdvancementProvider;
import com.github.iunius118.chilibulletweapons.data.ModBlockTagsProvider;
import com.github.iunius118.chilibulletweapons.data.ModDataMapProvider;
import com.github.iunius118.chilibulletweapons.data.ModEntityTypeTagsProvider;
import com.github.iunius118.chilibulletweapons.data.ModItemModelProvider;
import com.github.iunius118.chilibulletweapons.data.ModItemTagsProvider;
import com.github.iunius118.chilibulletweapons.data.ModLanguageProvider;
import com.github.iunius118.chilibulletweapons.data.ModLootTableProvider;
import com.github.iunius118.chilibulletweapons.data.ModRecipeProvider;
import com.github.iunius118.chilibulletweapons.platform.NeoForgeChiliBulletWeaponsConfig;
import com.github.iunius118.chilibulletweapons.registry.NeoForgeModRegistries;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="chilibulletweapons")
public class ChiliBulletWeapons {
    public ChiliBulletWeapons(IEventBus modEventBus, ModContainer modContainer) {
        CommonClass.init();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeoForgeChiliBulletWeaponsConfig.COMMON_SPEC, "chilibulletweapons.toml");
        NeoForgeModRegistries.registerGameObjects(modEventBus);
        modEventBus.addListener(this::gatherData);
        if (FMLEnvironment.dist.isClient()) {
            ChiliBulletWeaponsClient.onInitializeClient(modEventBus);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        boolean includesServer = event.includeServer();
        dataGenerator.addProvider(includesServer, (DataProvider)blockTagsProvider);
        dataGenerator.addProvider(includesServer, (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        dataGenerator.addProvider(includesServer, (DataProvider)new ModEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        dataGenerator.addProvider(includesServer, (DataProvider)new ModLootTableProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(includesServer, (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(includesServer, (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
        dataGenerator.addProvider(includesServer, (DataProvider)new ModDataMapProvider(packOutput, lookupProvider));
        boolean includesClient = event.includeClient();
        dataGenerator.addProvider(includesClient, (DataProvider)new ModLanguageProvider(packOutput));
        dataGenerator.addProvider(includesClient, (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
    }
}

