/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons;

import com.github.iunius118.chilibulletweapons.Constants;
import com.github.iunius118.chilibulletweapons.client.ChiliArrowRenderer;
import com.github.iunius118.chilibulletweapons.client.ChiliBulletModel;
import com.github.iunius118.chilibulletweapons.client.ChiliBulletRenderer;
import com.github.iunius118.chilibulletweapons.client.DyedGunItemColor;
import com.github.iunius118.chilibulletweapons.client.ModItemProperties;
import com.github.iunius118.chilibulletweapons.entity.ModEntityTypes;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class ChiliBulletWeaponsClient {
    public static void onInitializeClient(IEventBus modEventBus) {
        modEventBus.addListener(ChiliBulletWeaponsClient::onClientSetup);
        modEventBus.addListener(ChiliBulletWeaponsClient::onItemColorHandlerEvent);
        modEventBus.addListener(ChiliBulletWeaponsClient::onRegisterLayerDefinitions);
        modEventBus.addListener(ChiliBulletWeaponsClient::onRegisterEntityRenderer);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        ChiliBulletWeaponsClient.registerItemProperties();
    }

    private static void registerItemProperties() {
        ItemProperties.register((Item)ModItems.GUN, (ResourceLocation)Constants.ItemProperties.PROPERTY_GUN, (ItemPropertyFunction)ModItemProperties.PROPERTY_GUN);
    }

    public static void onItemColorHandlerEvent(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new DyedGunItemColor(), new ItemLike[]{ModItems.GUN});
    }

    private static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ChiliBulletModel.LAYER_LOCATION, ChiliBulletModel::createBodyLayer);
    }

    private static void onRegisterEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntityTypes.CHILI_ARROW, ChiliArrowRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.CHILI_BULLET, ChiliBulletRenderer::new);
    }
}

