/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.client;

import com.github.iunius118.chilibulletweapons.CommonClass;
import com.github.iunius118.chilibulletweapons.client.ChiliBulletModel;
import com.github.iunius118.chilibulletweapons.entity.ChiliBullet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ChiliBulletRenderer
extends EntityRenderer<ChiliBullet> {
    public static final ResourceLocation TEXTURE_LOCATION = CommonClass.modLocation("textures/entity/chili_bullet.png");
    private final ChiliBulletModel<ChiliBullet> model;

    public ChiliBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ChiliBulletModel(context.bakeLayer(ChiliBulletModel.LAYER_LOCATION));
    }

    public void render(ChiliBullet chiliBullet, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (chiliBullet.getAge() > 1) {
            poseStack.pushPose();
            this.model.setupAnim(chiliBullet, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            VertexConsumer buffer = bufferSource.getBuffer(this.model.renderType(TEXTURE_LOCATION));
            this.model.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            poseStack.popPose();
        }
        super.render((Entity)chiliBullet, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(ChiliBullet entity) {
        return TEXTURE_LOCATION;
    }
}

