/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.component;

import com.github.iunius118.chilibulletweapons.component.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public record DyedGunColors(int metalRGB, int woodRGB, int bladeRGB, boolean showInTooltip) {
    public static final DyedGunColors DEFAULT = new DyedGunColors(0xFFFFFF, 0xFFFFFF, 0xFFFFFF, true);
    public static final Codec<DyedGunColors> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("metal_rgb", (Object)0xFFFFFF).forGetter(DyedGunColors::metalRGB), (App)Codec.INT.optionalFieldOf("wood_rgb", (Object)0xFFFFFF).forGetter(DyedGunColors::woodRGB), (App)Codec.INT.optionalFieldOf("blade_rgb", (Object)0xFFFFFF).forGetter(DyedGunColors::bladeRGB), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(DyedGunColors::showInTooltip)).apply((Applicative)instance, DyedGunColors::new));
    public static final StreamCodec<ByteBuf, DyedGunColors> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DyedGunColors::metalRGB, (StreamCodec)ByteBufCodecs.INT, DyedGunColors::woodRGB, (StreamCodec)ByteBufCodecs.INT, DyedGunColors::bladeRGB, (StreamCodec)ByteBufCodecs.BOOL, DyedGunColors::showInTooltip, DyedGunColors::new);

    public static DyedGunColors getOrDefault(ItemStack stack) {
        return (DyedGunColors)stack.getOrDefault(ModDataComponents.DYED_GUN_COLORS, (Object)DEFAULT);
    }

    public int metalColor() {
        return FastColor.ARGB32.opaque((int)this.metalRGB);
    }

    public int woodColor() {
        return FastColor.ARGB32.opaque((int)this.woodRGB);
    }

    public int bladeColor() {
        return FastColor.ARGB32.opaque((int)this.bladeRGB);
    }

    public void addToTooltip(List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.showInTooltip && tooltipFlag.isAdvanced()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", this.metalRGB)}).withStyle(ChatFormatting.DARK_GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", this.woodRGB)}).withStyle(ChatFormatting.DARK_GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", this.bladeRGB)}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

