/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.component;

import com.github.iunius118.chilibulletweapons.component.ModDataComponents;
import com.github.iunius118.chilibulletweapons.item.ChiliBulletGunHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record GunContents(int quickLoading, int piercing, int barrelCount, boolean showInTooltip) {
    public static final int DEFAULT_QUICK_LOADING = 0;
    public static final int DEFAULT_PIERCING = 0;
    public static final int DEFAULT_BARREL_COUNT = 1;
    public static final GunContents DEFAULT = new GunContents(0, 0, 1, true);
    public static final Codec<GunContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("quick_loading", (Object)0).forGetter(GunContents::quickLoading), (App)ExtraCodecs.intRange((int)0, (int)5).optionalFieldOf("piercing", (Object)0).forGetter(GunContents::piercing), (App)ExtraCodecs.intRange((int)1, (int)4).optionalFieldOf("barrel_count", (Object)1).forGetter(GunContents::barrelCount), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(GunContents::showInTooltip)).apply((Applicative)instance, GunContents::new));
    public static final StreamCodec<ByteBuf, GunContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, GunContents::quickLoading, (StreamCodec)ByteBufCodecs.INT, GunContents::piercing, (StreamCodec)ByteBufCodecs.INT, GunContents::barrelCount, (StreamCodec)ByteBufCodecs.BOOL, GunContents::showInTooltip, GunContents::new);

    public static GunContents getOrDefault(ItemStack stack) {
        return (GunContents)stack.getOrDefault(ModDataComponents.GUN_CONTENTS, (Object)DEFAULT);
    }

    public ItemStack setTo(ItemStack stack) {
        stack.set(ModDataComponents.GUN_CONTENTS, (Object)this);
        return stack;
    }

    public static int getQuickLoading(ItemStack stack) {
        return GunContents.getOrDefault((ItemStack)stack).quickLoading;
    }

    public static int getPiercing(ItemStack stack) {
        return GunContents.getOrDefault((ItemStack)stack).piercing;
    }

    public static int getBarrelCount(ItemStack stack) {
        return GunContents.getOrDefault((ItemStack)stack).barrelCount;
    }

    public GunContents setQuickLoading(int newQuickLoading) {
        return new GunContents(newQuickLoading, this.piercing, this.barrelCount, this.showInTooltip);
    }

    public GunContents setPiercing(int newPiercing) {
        return new GunContents(this.quickLoading, newPiercing, this.barrelCount, this.showInTooltip);
    }

    public GunContents setBarrelCount(int newBarrelCount) {
        return new GunContents(this.quickLoading, this.piercing, newBarrelCount, this.showInTooltip);
    }

    public void addToTooltip(List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.showInTooltip) {
            if (this.quickLoading > 0) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.chilibulletweapons.quick_load", (Object[])new Object[]{this.quickLoading}).withStyle(ChatFormatting.GRAY));
            }
            if (tooltipFlag.isAdvanced()) {
                String shootingPower = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(ChiliBulletGunHelper.getShootingPower(this.piercing));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.chilibulletweapons.barrel_info", (Object[])new Object[]{shootingPower, this.piercing, this.barrelCount}).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

