/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.data;

import com.github.iunius118.chilibulletweapons.Constants;
import com.github.iunius118.chilibulletweapons.advancements.ExplodedChiliArrowTrigger;
import com.github.iunius118.chilibulletweapons.advancements.KilledByChiliBulletTrigger;
import com.github.iunius118.chilibulletweapons.advancements.ShotChiliBulletGunTrigger;
import com.github.iunius118.chilibulletweapons.advancements.UpgradedChiliBulletGunTrigger;
import com.github.iunius118.chilibulletweapons.component.GunContents;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModAdvancementProvider
extends AdvancementProvider {
    public ModAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new ModAdvancementGenerator()));
    }

    private static class ModAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        private ModAdvancementGenerator() {
        }

        public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            Item curvedChiliItem = this.getItem(Constants.Items.CURVED_CHILI);
            AdvancementHolder root = Advancement.Builder.recipeAdvancement().display((ItemLike)this.getItem(Constants.Items.ICON_MAIN), (Component)Component.translatable((String)"advancements.%s.main.root.title".formatted("chilibulletweapons")), (Component)Component.translatable((String)"advancements.%s.main.root.description".formatted("chilibulletweapons")), ResourceLocation.withDefaultNamespace((String)"textures/block/orange_concrete_powder.png"), AdvancementType.TASK, false, false, false).addCriterion("has_curved_chili", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{curvedChiliItem})).save(consumer, "%s:main/root".formatted("chilibulletweapons"));
            AdvancementHolder bulletChili = this.addItemAdvancement(root, ModItems.BULLET_CHILI, AdvancementType.TASK, new Item[]{ModItems.BULLET_CHILI}, "main", consumer);
            String explodedChiliArrowName = "exploded_chili_arrow";
            AdvancementHolder explodedChiliArrow = Advancement.Builder.recipeAdvancement().parent(bulletChili).display((ItemLike)ModItems.CHILI_ARROW, (Component)Component.translatable((String)"advancements.%s.%s.%s.title".formatted("chilibulletweapons", "main", explodedChiliArrowName)), (Component)Component.translatable((String)"advancements.%s.%s.%s.description".formatted("chilibulletweapons", "main", explodedChiliArrowName)), null, AdvancementType.TASK, true, true, false).addCriterion(explodedChiliArrowName, ExplodedChiliArrowTrigger.TriggerInstance.explodedChiliArrow()).save(consumer, "%s:%s/%s".formatted("chilibulletweapons", "main", explodedChiliArrowName));
            AdvancementHolder shotGun = this.addShotGunAdvancement(bulletChili, ModItems.GUN, AdvancementType.TASK, new Item[]{ModItems.GUN, ModItems.MACHINE_GUN}, "main", consumer);
            String upgradedGunName = "upgraded_gun";
            AdvancementHolder upgradedChiliBulletGun = Advancement.Builder.recipeAdvancement().parent(shotGun).display((ItemLike)ModItems.GUN, (Component)Component.translatable((String)"advancements.%s.%s.%s.title".formatted("chilibulletweapons", "main", upgradedGunName)), (Component)Component.translatable((String)"advancements.%s.%s.%s.description".formatted("chilibulletweapons", "main", upgradedGunName)), null, AdvancementType.TASK, true, true, false).addCriterion("upgraded_barrel", UpgradedChiliBulletGunTrigger.TriggerInstance.upgradedChiliBulletGun((ItemLike)ModItems.UPGRADE_GUN_BARREL)).addCriterion("upgraded_bayonet", UpgradedChiliBulletGunTrigger.TriggerInstance.upgradedChiliBulletGun((ItemLike)ModItems.UPGRADE_GUN_BAYONET)).addCriterion("upgraded_mechanism", UpgradedChiliBulletGunTrigger.TriggerInstance.upgradedChiliBulletGun((ItemLike)ModItems.UPGRADE_GUN_MECHANISM)).requirements(AdvancementRequirements.Strategy.OR).save(consumer, "%s:%s/%s".formatted("chilibulletweapons", "main", upgradedGunName));
            String killedByChiliBulletName = "killed_by_chili_bullet";
            AdvancementHolder killedByChiliBullet = Advancement.Builder.recipeAdvancement().parent(upgradedChiliBulletGun).display(GunContents.DEFAULT.setPiercing(3).setTo(new ItemStack((ItemLike)ModItems.GUN)), (Component)Component.translatable((String)"advancements.%s.%s.%s.title".formatted("chilibulletweapons", "main", killedByChiliBulletName)), (Component)Component.translatable((String)"advancements.%s.%s.%s.description".formatted("chilibulletweapons", "main", killedByChiliBulletName)), null, AdvancementType.CHALLENGE, true, true, true).rewards(AdvancementRewards.Builder.experience((int)75)).addCriterion(killedByChiliBulletName, KilledByChiliBulletTrigger.TriggerInstance.killedByBullet(MinMaxBounds.Ints.atLeast((int)4))).save(consumer, "%s:%s/%s".formatted("chilibulletweapons", "main", killedByChiliBulletName));
            AdvancementHolder shotMachineGun = this.addShotGunAdvancement(shotGun, ModItems.MACHINE_GUN, AdvancementType.TASK, new Item[]{ModItems.MACHINE_GUN}, "main", consumer);
            AdvancementHolder machineGunWithMending = this.addEnchantmentAdvancement(shotMachineGun, ModItems.MACHINE_GUN, AdvancementType.GOAL, new Item[]{ModItems.MACHINE_GUN}, (ResourceKey<Enchantment>)Enchantments.MENDING, 1, provider, "main", consumer);
        }

        private AdvancementHolder addItemAdvancement(AdvancementHolder parent, Item icon, AdvancementType advancementType, Item[] requirements, String tab, Consumer<AdvancementHolder> consumer) {
            String name = this.getItemId(requirements[0]).getPath();
            Advancement.Builder builder = Advancement.Builder.recipeAdvancement().parent(parent).display((ItemLike)icon, (Component)Component.translatable((String)"advancements.%s.%s.%s.title".formatted("chilibulletweapons", tab, name)), (Component)Component.translatable((String)"advancements.%s.%s.%s.description".formatted("chilibulletweapons", tab, name)), null, advancementType, true, true, false).requirements(AdvancementRequirements.Strategy.OR);
            for (Item item : requirements) {
                String itemName = this.getItemId(item).getPath();
                builder.addCriterion("has_" + itemName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
            }
            return builder.save(consumer, "%s:%s/%s".formatted("chilibulletweapons", tab, name));
        }

        private AdvancementHolder addShotGunAdvancement(AdvancementHolder parent, Item icon, AdvancementType advancementType, Item[] requirements, String tab, Consumer<AdvancementHolder> consumer) {
            String name = "shot_" + this.getItemId(requirements[0]).getPath();
            Advancement.Builder builder = Advancement.Builder.recipeAdvancement().parent(parent).display((ItemLike)icon, (Component)Component.translatable((String)"advancements.%s.%s.%s.title".formatted("chilibulletweapons", tab, name)), (Component)Component.translatable((String)"advancements.%s.%s.%s.description".formatted("chilibulletweapons", tab, name)), null, advancementType, true, true, false).requirements(AdvancementRequirements.Strategy.OR);
            for (Item item : requirements) {
                String itemName = this.getItemId(item).getPath();
                builder.addCriterion("shot_" + itemName, ShotChiliBulletGunTrigger.TriggerInstance.shotChiliBulletGun((ItemLike)item));
            }
            return builder.save(consumer, "%s:%s/%s".formatted("chilibulletweapons", tab, name));
        }

        private AdvancementHolder addEnchantmentAdvancement(AdvancementHolder parent, Item icon, AdvancementType advancementType, Item[] requirements, ResourceKey<Enchantment> enchantment, int level, HolderLookup.Provider lookupProvider, String tab, Consumer<AdvancementHolder> consumer) {
            Holder.Reference enchantmentHolder = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantment);
            String name = this.getItemId(requirements[0]).getPath() + "_" + this.getEnchantmentId((Holder<Enchantment>)enchantmentHolder).getPath() + "_" + level;
            Advancement.Builder builder = Advancement.Builder.recipeAdvancement().parent(parent).display((ItemLike)icon, (Component)Component.translatable((String)"advancements.%s.%s.%s.title".formatted("chilibulletweapons", tab, name)), (Component)Component.translatable((String)"advancements.%s.%s.%s.description".formatted("chilibulletweapons", tab, name)), null, advancementType, true, true, false).requirements(AdvancementRequirements.Strategy.OR);
            for (Item item : requirements) {
                String itemName = this.getItemId(item).getPath();
                ItemPredicate itemPredicate = ItemPredicate.Builder.item().of(new ItemLike[]{item}).withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantmentHolder, MinMaxBounds.Ints.atLeast((int)level))))).build();
                builder.addCriterion("has_" + itemName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{itemPredicate}));
            }
            return builder.save(consumer, "%s:%s/%s".formatted("chilibulletweapons", tab, name));
        }

        private Item getItem(ResourceLocation id) {
            return (Item)BuiltInRegistries.ITEM.get(id);
        }

        private ResourceLocation getItemId(Item item) {
            return BuiltInRegistries.ITEM.getKey((Object)item);
        }

        private ResourceLocation getEnchantmentId(Holder<Enchantment> enchantment) {
            return ((ResourceKey)enchantment.unwrapKey().orElseThrow()).location();
        }
    }
}

