/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.data;

import com.github.iunius118.chilibulletweapons.Constants;
import com.github.iunius118.chilibulletweapons.client.GunItemPropertyFunction;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "chilibulletweapons", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem(ModItems.BULLET_CHILI);
        this.basicItem(ModItems.BULLET_CHILI_SACK);
        this.basicItem(ModItems.CHILI_ARROW);
        this.basicItem(ModItems.CHILI_BULLET);
        this.basicItem(ModItems.UPGRADE_GUN_BAYONET);
        this.basicItem(ModItems.UPGRADE_GUN_BARREL);
        this.basicItem(ModItems.UPGRADE_GUN_MECHANISM);
        this.registerGunModels();
    }

    private void registerGunModels() {
        ModelFile.UncheckedModelFile parent = new ModelFile.UncheckedModelFile("item/generated");
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("gun_short_closed")).parent((ModelFile)parent)).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(0.68f).rotation(0.0f, -90.0f, 25.0f).translation(3.0f, 3.2f, 1.13f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(0.68f).rotation(0.0f, 90.0f, -25.0f).translation(3.0f, 3.2f, 1.13f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(0.85f).rotation(-40.0f, -90.0f, 0.0f).translation(0.0f, 1.0f, -0.25f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(0.85f).rotation(-40.0f, 90.0f, 0.0f).translation(0.0f, 1.0f, -0.25f).end().end();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("gun_short_open")).parent((ModelFile)parent)).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(0.68f).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(0.68f).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(0.85f).rotation(-40.0f, -90.0f, 0.0f).translation(0.0f, 1.0f, -0.25f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(0.85f).rotation(-40.0f, 90.0f, 0.0f).translation(0.0f, 1.0f, -0.25f).end().end();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("gun_long_closed")).parent((ModelFile)parent)).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(0.68f).rotation(0.0f, -90.0f, 25.0f).translation(3.0f, 3.2f, -0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(0.68f).rotation(0.0f, 90.0f, -25.0f).translation(3.0f, 3.2f, -0.4f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(0.85f).rotation(-40.0f, -90.0f, 0.0f).translation(0.0f, 0.5f, -2.2f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(0.85f).rotation(-40.0f, 90.0f, 0.0f).translation(0.0f, 0.5f, -2.2f).end().end();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("gun_long_open")).parent((ModelFile)parent)).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(0.68f).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, -0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(0.68f).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, -0.4f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(0.85f).rotation(-40.0f, -90.0f, 0.0f).translation(0.0f, 0.5f, -2.2f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(0.85f).rotation(-40.0f, 90.0f, 0.0f).translation(0.0f, 0.5f, -2.2f).end().end();
        this.addGunModels((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("gun")).parent((ModelFile)parent));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("machine_gun")).parent(this.getModelFile("gun_long_closed"))).texture("layer0", "item/machine_gun");
    }

    private void addGunModels(ItemModelBuilder builder) {
        List<String> guns = List.of("pistol", "rifle", "volley_gun");
        block5: for (int i = 0; i < 32; ++i) {
            int gunIndex = i & 3;
            if (gunIndex == 3) continue;
            ItemModelBuilder.OverrideBuilder override = builder.override();
            boolean isDyed = false;
            boolean isBayoneted = false;
            boolean isLoading = false;
            String prefix = "";
            Object suffix = "";
            String action = "_closed";
            if ((i & 0x10) != 0) {
                isDyed = true;
                prefix = "dyed_gun/dyed_";
            }
            if ((i & 8) != 0) {
                isLoading = true;
                suffix = (String)suffix + "_loading";
                action = "_open";
            }
            if ((i & 4) != 0) {
                isBayoneted = true;
                suffix = "_bayoneted" + (String)suffix;
            }
            String modelName = prefix + guns.get(gunIndex) + (String)suffix;
            switch (gunIndex) {
                case 0: {
                    ItemModelBuilder modelBuilder;
                    override.predicate(Constants.ItemProperties.PROPERTY_GUN, GunItemPropertyFunction.getValue(isDyed, isLoading, isBayoneted, false, false)).model(this.getModelFile(modelName)).end();
                    if (isDyed) {
                        modelBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + modelName)).parent(this.getModelFile("gun_short" + action))).texture("layer0", "item/" + modelName + "_0")).texture("layer1", "item/" + modelName + "_1");
                        if (!isBayoneted) continue block5;
                        modelBuilder.texture("layer2", "item/" + modelName + "_2");
                        continue block5;
                    }
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modelName)).parent(this.getModelFile("gun_short" + action))).texture("layer0", "item/" + modelName);
                    continue block5;
                }
                case 1: {
                    ItemModelBuilder modelBuilder;
                    override.predicate(Constants.ItemProperties.PROPERTY_GUN, GunItemPropertyFunction.getValue(isDyed, isLoading, isBayoneted, false, true)).model(this.getModelFile(modelName)).end();
                    if (isDyed) {
                        modelBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + modelName)).parent(this.getModelFile("gun_long" + action))).texture("layer0", "item/" + modelName + "_0")).texture("layer1", "item/" + modelName + "_1");
                        if (!isBayoneted) continue block5;
                        modelBuilder.texture("layer2", "item/" + modelName + "_2");
                        continue block5;
                    }
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modelName)).parent(this.getModelFile("gun_long" + action))).texture("layer0", "item/" + modelName);
                    continue block5;
                }
                case 2: {
                    ItemModelBuilder modelBuilder;
                    override.predicate(Constants.ItemProperties.PROPERTY_GUN, GunItemPropertyFunction.getValue(isDyed, isLoading, isBayoneted, true, false)).model(this.getModelFile(modelName)).end();
                    if (isDyed) {
                        modelBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + modelName)).parent(this.getModelFile("gun_long" + action))).texture("layer0", "item/" + modelName + "_0")).texture("layer1", "item/" + modelName + "_1");
                        if (!isBayoneted) continue block5;
                        modelBuilder.texture("layer2", "item/" + modelName + "_2");
                        continue block5;
                    }
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modelName)).parent(this.getModelFile("gun_long" + action))).texture("layer0", "item/" + modelName);
                }
            }
        }
    }

    private ResourceLocation getModelLocation(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("item/" + name));
    }

    private ModelFile getModelFile(String name) {
        return new ModelFile.UncheckedModelFile(this.getModelLocation(name));
    }

    private ResourceLocation getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }
}

