/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.data;

import com.github.iunius118.chilibulletweapons.Constants;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ModLootTableProvider
extends LootTableProvider {
    public ModLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), VanillaLootTableProvider.create((PackOutput)packOutput, lookupProvider).getTables(), lookupProvider);
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(ModBlockLootTables::new, LootContextParamSets.BLOCK));
    }

    private static class ModBlockLootTables
    extends BlockLootSubProvider {
        private final Block chiliPepper = this.getBlock(Constants.Blocks.CHILI_PEPPER);
        private final Item chiliSeeds = this.getItem(Constants.Items.CHILI_SEEDS);
        private final Item curvedGreenChili = this.getItem(Constants.Items.CURVED_GREEN_CHILI);
        private final Item curvedChili = this.getItem(Constants.Items.CURVED_CHILI);

        public ModBlockLootTables(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            this.add(this.chiliPepper, this.createChiliPepperCropDrops());
        }

        private LootTable.Builder createChiliPepperCropDrops() {
            LootItemBlockStatePropertyCondition.Builder chiliSeedCondition = new LootItemBlockStatePropertyCondition.Builder(this.chiliPepper){

                public LootItemCondition build() {
                    ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)chiliPepper));
                    Holder.Reference blockHolder = BuiltInRegistries.BLOCK.getHolderOrThrow(key);
                    return new LootItemBlockStatePropertyCondition((Holder)blockHolder, this.getChiliPepperOutOfHarvestAgePredicate());
                }
            };
            LootItemBlockStatePropertyCondition.Builder greenChiliCondition = new LootItemBlockStatePropertyCondition.Builder(this.chiliPepper).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 6));
            LootItemBlockStatePropertyCondition.Builder curvedChiliCondition = new LootItemBlockStatePropertyCondition.Builder(this.chiliPepper).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7));
            Holder.Reference fortune = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
            LootTable.Builder lootTableBuilder = LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)chiliSeedCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.chiliSeeds))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)greenChiliCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.curvedGreenChili))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)curvedChiliCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.curvedChili))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)curvedChiliCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.BULLET_CHILI))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)greenChiliCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.curvedGreenChili).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5714286f, (int)2)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)curvedChiliCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.curvedChili).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5714286f, (int)2)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)curvedChiliCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.BULLET_CHILI).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5714286f, (int)2))));
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)this.chiliPepper, (FunctionUserBuilder)lootTableBuilder);
        }

        private Optional<StatePropertiesPredicate> getChiliPepperOutOfHarvestAgePredicate() {
            RegistryOps serializationContext = this.registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            JsonObject rangeJson = new JsonObject();
            rangeJson.addProperty("min", "0");
            rangeJson.addProperty("max", String.valueOf(5));
            JsonObject ageJson = new JsonObject();
            ageJson.add(CropBlock.AGE.getName(), (JsonElement)rangeJson);
            return StatePropertiesPredicate.CODEC.parse((DynamicOps)serializationContext, (Object)ageJson).result();
        }

        protected Iterable<Block> getKnownBlocks() {
            return List.of(this.chiliPepper);
        }

        private Block getBlock(ResourceLocation id) {
            return (Block)BuiltInRegistries.BLOCK.get(id);
        }

        private Item getItem(ResourceLocation id) {
            return (Item)BuiltInRegistries.ITEM.get(id);
        }
    }
}

