/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.item;

import com.github.iunius118.chilibulletweapons.component.GunContents;
import com.github.iunius118.chilibulletweapons.component.ModDataComponents;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import com.github.iunius118.chilibulletweapons.item.UpgradeGunPartItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;

public class ChiliBulletGunHelper {
    public static boolean isLoaded(ItemStack stack) {
        return ChiliBulletGunHelper.isLoaded((ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES));
    }

    public static boolean isLoaded(ChargedProjectiles chargedProjectiles) {
        return chargedProjectiles != null && !chargedProjectiles.isEmpty();
    }

    public static boolean isLoading(ItemStack stack) {
        return stack.has(ModDataComponents.LOADING);
    }

    public static void changeLoading(ItemStack stack, boolean isLoading) {
        if (stack.has(ModDataComponents.LOADING)) {
            if (!isLoading) {
                stack.remove(ModDataComponents.LOADING);
            }
        } else if (isLoading) {
            stack.set(ModDataComponents.LOADING, (Object)Unit.INSTANCE);
        }
    }

    public static int getQuickLoading(ItemStack stack) {
        return GunContents.getQuickLoading(stack);
    }

    public static int getPiercing(ItemStack stack) {
        return GunContents.getPiercing(stack);
    }

    public static int getBarrelCount(ItemStack stack) {
        return GunContents.getBarrelCount(stack);
    }

    public static boolean canMultishot(ItemStack stack) {
        return ChiliBulletGunHelper.getBarrelCount(stack) > 1;
    }

    public static boolean isBayoneted(ItemStack stack) {
        return stack.has(ModDataComponents.BAYONETED);
    }

    public static float getShootingPower(int piercing) {
        if (piercing < 1) {
            return 3.0f;
        }
        return 4.0f;
    }

    public static float getShootingPower(ItemStack stack) {
        return ChiliBulletGunHelper.getShootingPower(ChiliBulletGunHelper.getPiercing(stack));
    }

    public static float getInaccuracy(ItemStack stack) {
        if (ChiliBulletGunHelper.getPiercing(stack) < 1) {
            return 1.0f;
        }
        return 0.5f;
    }

    public static int getReloadDuration(ItemStack stack) {
        int quickLoading;
        int basicDuration = 14;
        if (ChiliBulletGunHelper.getBarrelCount(stack) > 1) {
            basicDuration = 22;
        }
        if (stack.has(ModDataComponents.BAYONETED)) {
            basicDuration += 2;
        }
        if ((quickLoading = ChiliBulletGunHelper.getQuickLoading(stack)) == 0) {
            return basicDuration;
        }
        return Math.max(0, basicDuration - 2 * quickLoading);
    }

    public static void setItemAttributeModifiers(ItemStack stack, float attackDamage, float attackSpeed) {
        ItemAttributeModifiers itemAttributeModifiers = ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)itemAttributeModifiers);
    }

    public static List<ItemStack> getCreativeGuns() {
        if (ModItems.GUN == null) {
            return List.of();
        }
        ArrayList<ItemStack> guns = new ArrayList<ItemStack>();
        ItemStack gun = new ItemStack((ItemLike)ModItems.GUN);
        guns.add(gun);
        if (ModItems.UPGRADE_GUN_BARREL == null || ModItems.UPGRADE_GUN_BAYONET == null) {
            return guns;
        }
        UpgradeGunPartItem upgradeGunBarrel = (UpgradeGunPartItem)ModItems.UPGRADE_GUN_BARREL;
        UpgradeGunPartItem upgradeGunBayonet = (UpgradeGunPartItem)ModItems.UPGRADE_GUN_BAYONET;
        ItemStack rifle = upgradeGunBarrel.upgrade(gun);
        ItemStack volleyGun = upgradeGunBarrel.upgrade(rifle);
        guns.add(rifle);
        guns.add(volleyGun);
        guns.add(upgradeGunBayonet.upgrade(gun));
        guns.add(upgradeGunBayonet.upgrade(rifle));
        guns.add(upgradeGunBayonet.upgrade(volleyGun));
        return guns;
    }

    private ChiliBulletGunHelper() {
    }
}

