/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.mixin;

import com.github.iunius118.chilibulletweapons.item.ChiliBulletGunItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class MixinCrossbowItem {
    @Inject(method={"getChargeDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onGetChargeDuration(ItemStack stack, LivingEntity shooter, CallbackInfoReturnable<Integer> cir) {
        Item item = stack.getItem();
        if (item instanceof ChiliBulletGunItem) {
            ChiliBulletGunItem chiliBulletGun = (ChiliBulletGunItem)item;
            int reloadDuration = chiliBulletGun.getReloadDuration(stack);
            cir.setReturnValue((Object)reloadDuration);
        }
    }

    @Inject(method={"performShooting"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPerformShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, float velocity, float inaccuracy, LivingEntity target, CallbackInfo ci) {
        Item item = weapon.getItem();
        if (item instanceof ChiliBulletGunItem) {
            ChiliBulletGunItem chiliBulletGun = (ChiliBulletGunItem)item;
            chiliBulletGun.performShootingByNonPlayer(level, shooter, hand, weapon);
            ci.cancel();
        }
    }
}

