/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.platform;

import com.github.iunius118.chilibulletweapons.platform.services.IChiliBulletWeaponsConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeChiliBulletWeaponsConfig
implements IChiliBulletWeaponsConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;

    @Override
    public boolean canMultishotMultiHit() {
        return COMMON_SPEC.isLoaded() ? (Boolean)NeoForgeChiliBulletWeaponsConfig.COMMON.canMultishotMultiHit.get() : (Boolean)NeoForgeChiliBulletWeaponsConfig.COMMON.canMultishotMultiHit.getDefault();
    }

    @Override
    public float getChiliArrowDamageMultiplier() {
        Double d = COMMON_SPEC.isLoaded() ? (Double)NeoForgeChiliBulletWeaponsConfig.COMMON.chiliArrowDamageMultiplier.get() : (Double)NeoForgeChiliBulletWeaponsConfig.COMMON.chiliArrowDamageMultiplier.getDefault();
        return d.floatValue();
    }

    @Override
    public double getChiliBulletBaseDamage() {
        return COMMON_SPEC.isLoaded() ? (Double)NeoForgeChiliBulletWeaponsConfig.COMMON.chiliBulletBaseDamage.get() : (Double)NeoForgeChiliBulletWeaponsConfig.COMMON.chiliBulletBaseDamage.getDefault();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ModConfigSpec.BooleanValue canMultishotMultiHit;
        public final ModConfigSpec.DoubleValue chiliArrowDamageMultiplier;
        public final ModConfigSpec.DoubleValue chiliBulletBaseDamage;

        public CommonConfig(ModConfigSpec.Builder builder) {
            builder.push("common");
            this.canMultishotMultiHit = builder.define("canMultishotMultiHit", true);
            this.chiliArrowDamageMultiplier = builder.defineInRange("chiliArrowDamageMultiplier", 1.0, 0.0, 8.0);
            this.chiliBulletBaseDamage = builder.defineInRange("chiliBulletBaseDamage", 0.85, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }
}

