/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.chilibulletweapons.registry;

import com.github.iunius118.chilibulletweapons.Constants;
import com.github.iunius118.chilibulletweapons.advancements.ModCriteriaTriggers;
import com.github.iunius118.chilibulletweapons.component.ModDataComponents;
import com.github.iunius118.chilibulletweapons.entity.ModEntityTypes;
import com.github.iunius118.chilibulletweapons.item.ModItems;
import com.github.iunius118.chilibulletweapons.sounds.ModSoundEvents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeModRegistries {
    public static void registerGameObjects(IEventBus modEventBus) {
        NeoForgeModRegistries.registerItems(modEventBus);
        NeoForgeModRegistries.registerSoundEvents(modEventBus);
        NeoForgeModRegistries.registerEntityTypes(modEventBus);
        NeoForgeModRegistries.registerDataComponentTypes(modEventBus);
        NeoForgeModRegistries.registerCriterionTriggers(modEventBus);
        modEventBus.addListener(NeoForgeModRegistries::onCreativeModeTabBuildContents);
    }

    private static void registerItems(IEventBus modEventBus) {
        DeferredRegister.Items itemRegister = DeferredRegister.createItems((String)"chilibulletweapons");
        itemRegister.register(Constants.Items.BULLET_CHILI.getPath(), () -> ModItems.BULLET_CHILI);
        itemRegister.register(Constants.Items.BULLET_CHILI_SACK.getPath(), () -> ModItems.BULLET_CHILI_SACK);
        itemRegister.register(Constants.Items.CHILI_ARROW.getPath(), () -> ModItems.CHILI_ARROW);
        itemRegister.register(Constants.Items.CHILI_BULLET.getPath(), () -> ModItems.CHILI_BULLET);
        itemRegister.register(Constants.Items.GUN.getPath(), () -> ModItems.GUN);
        itemRegister.register(Constants.Items.MACHINE_GUN.getPath(), () -> ModItems.MACHINE_GUN);
        itemRegister.register(Constants.Items.UPGRADE_GUN_BAYONET.getPath(), () -> ModItems.UPGRADE_GUN_BAYONET);
        itemRegister.register(Constants.Items.UPGRADE_GUN_BARREL.getPath(), () -> ModItems.UPGRADE_GUN_BARREL);
        itemRegister.register(Constants.Items.UPGRADE_GUN_MECHANISM.getPath(), () -> ModItems.UPGRADE_GUN_MECHANISM);
        itemRegister.register(modEventBus);
    }

    private static void registerSoundEvents(IEventBus modEventBus) {
        DeferredRegister soundEventRegister = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"chilibulletweapons");
        soundEventRegister.register(Constants.SoundEvents.GUN_SHOOT.getPath(), () -> ModSoundEvents.GUN_SHOOT);
        soundEventRegister.register(Constants.SoundEvents.GUN_ACTION_OPEN.getPath(), () -> ModSoundEvents.GUN_ACTION_OPEN);
        soundEventRegister.register(Constants.SoundEvents.GUN_ACTION_CLOSE.getPath(), () -> ModSoundEvents.GUN_ACTION_CLOSE);
        soundEventRegister.register(Constants.SoundEvents.GUN_UPGRADE.getPath(), () -> ModSoundEvents.GUN_UPGRADE);
        soundEventRegister.register(modEventBus);
    }

    private static void registerEntityTypes(IEventBus modEventBus) {
        DeferredRegister entityTypeRegister = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"chilibulletweapons");
        entityTypeRegister.register(Constants.EntityTypes.CHILI_ARROW.getPath(), () -> ModEntityTypes.CHILI_ARROW);
        entityTypeRegister.register(Constants.EntityTypes.CHILI_BULLET.getPath(), () -> ModEntityTypes.CHILI_BULLET);
        entityTypeRegister.register(modEventBus);
    }

    private static void registerDataComponentTypes(IEventBus modEventBus) {
        DeferredRegister dataComponentTypeRegister = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"chilibulletweapons");
        dataComponentTypeRegister.register(Constants.DataComponentTypes.LOADING.getPath(), () -> ModDataComponents.LOADING);
        dataComponentTypeRegister.register(Constants.DataComponentTypes.GUN_CONTENTS.getPath(), () -> ModDataComponents.GUN_CONTENTS);
        dataComponentTypeRegister.register(Constants.DataComponentTypes.BAYONETED.getPath(), () -> ModDataComponents.BAYONETED);
        dataComponentTypeRegister.register(Constants.DataComponentTypes.FIXED.getPath(), () -> ModDataComponents.FIXED);
        dataComponentTypeRegister.register(Constants.DataComponentTypes.DYED_GUN_COLORS.getPath(), () -> ModDataComponents.DYED_GUN_COLORS);
        dataComponentTypeRegister.register(modEventBus);
    }

    private static void registerCriterionTriggers(IEventBus modEventBus) {
        DeferredRegister criterionTriggerRegistry = DeferredRegister.create((ResourceKey)Registries.TRIGGER_TYPE, (String)"chilibulletweapons");
        criterionTriggerRegistry.register(Constants.CriterionTriggers.EXPLODED_CHILI_ARROW.getPath(), () -> ModCriteriaTriggers.EXPLODED_CHILI_ARROW);
        criterionTriggerRegistry.register(Constants.CriterionTriggers.SHOT_CHILI_BULLET_GUN.getPath(), () -> ModCriteriaTriggers.SHOT_CHILI_BULLET_GUN);
        criterionTriggerRegistry.register(Constants.CriterionTriggers.UPGRADED_CHILI_BULLET_GUN.getPath(), () -> ModCriteriaTriggers.UPGRADED_CHILI_BULLET_GUN);
        criterionTriggerRegistry.register(Constants.CriterionTriggers.KILLED_BY_CHILI_BULLET.getPath(), () -> ModCriteriaTriggers.KILLED_BY_CHILI_BULLET);
        criterionTriggerRegistry.register(modEventBus);
    }

    private static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        CreativeModeTab creativeModeTab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(Constants.CreativeModeTabs.MAIN);
        if (event.getTab().equals(creativeModeTab)) {
            ModItems.getCreativeModeTabItems().forEach(i -> {
                if (i != null) {
                    event.accept(i);
                }
            });
        }
    }
}

