/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.ai;

import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EAIAvoidEntityGoal<T extends LivingEntity>
extends Goal {
    protected final PathfinderMob goalOwner;
    protected final Class<T> classToAvoid;
    protected final EAIData<Integer> avoidDistanceFar;
    protected final EAIData<Integer> avoidDistanceNear;
    protected final EAIData<Double> farSpeed;
    protected final EAIData<Double> nearSpeed;
    protected final EAIData<Integer> horizontalDistance;
    protected final EAIData<Integer> verticalDistance;
    private final TargetingConditions builtTargetSelector;
    protected T avoidTarget;
    protected Path path;

    protected EAIAvoidEntityGoal(Builder<T> builder) {
        this.goalOwner = builder.goalOwner;
        this.classToAvoid = builder.classToAvoid;
        this.avoidDistanceFar = builder.avoidDistanceFar;
        this.avoidDistanceNear = builder.avoidDistanceNear;
        this.farSpeed = builder.farSpeed;
        this.nearSpeed = builder.nearSpeed;
        this.horizontalDistance = builder.horizontalDistance;
        this.verticalDistance = builder.verticalDistance;
        Predicate<LivingEntity> predicate = builder.predicate.and(EntitySelector.f_20406_);
        if (builder.idTagMatcher != null) {
            predicate = predicate.and(arg_0 -> ((IdTagMatcher)builder.idTagMatcher).matchesEntity(arg_0));
        }
        if (builder.entityTypesToAvoid != null) {
            predicate = predicate.and(e -> e.m_6095_().m_204039_(builder.entityTypesToAvoid));
        }
        this.builtTargetSelector = TargetingConditions.m_148352_().m_26883_((double)this.avoidDistanceFar.get((Entity)this.goalOwner).intValue()).m_26888_(predicate);
    }

    public boolean m_8036_() {
        this.avoidTarget = this.goalOwner.m_9236_().m_45963_(this.classToAvoid, this.builtTargetSelector, (LivingEntity)this.goalOwner, this.goalOwner.m_20185_(), this.goalOwner.m_20186_(), this.goalOwner.m_20189_(), this.goalOwner.m_20191_().m_82400_((double)this.avoidDistanceFar.get((Entity)this.goalOwner).intValue()));
        if (this.avoidTarget == null) {
            return false;
        }
        Vec3 away = DefaultRandomPos.m_148407_((PathfinderMob)this.goalOwner, (int)this.horizontalDistance.get((Entity)this.goalOwner), (int)this.verticalDistance.get((Entity)this.goalOwner), (Vec3)this.avoidTarget.m_20182_());
        if (away == null) {
            return false;
        }
        if (this.avoidTarget.m_20275_(away.f_82479_, away.f_82480_, away.f_82481_) < this.avoidTarget.m_20280_((Entity)this.goalOwner)) {
            return false;
        }
        this.path = this.goalOwner.m_21573_().m_26524_(away.f_82479_, away.f_82480_, away.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        return !this.goalOwner.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.goalOwner.m_21573_().m_26536_(this.path, this.farSpeed.get((Entity)this.goalOwner).doubleValue());
    }

    public void m_8041_() {
        this.avoidTarget = null;
    }

    public void m_8037_() {
        int near = this.avoidDistanceNear.get((Entity)this.goalOwner);
        if (this.goalOwner.m_20280_(this.avoidTarget) < (double)(near * near)) {
            this.goalOwner.m_21573_().m_26517_(this.nearSpeed.get((Entity)this.goalOwner).doubleValue());
        } else {
            this.goalOwner.m_21573_().m_26517_(this.farSpeed.get((Entity)this.goalOwner).doubleValue());
        }
    }

    public static class Builder<T extends LivingEntity> {
        private final PathfinderMob goalOwner;
        private final Class<T> classToAvoid;
        private final EAIData<Integer> avoidDistanceFar;
        private final EAIData<Integer> avoidDistanceNear;
        private final EAIData<Double> farSpeed;
        private final EAIData<Double> nearSpeed;
        private final EAIData<Integer> horizontalDistance;
        private final EAIData<Integer> verticalDistance;
        private Predicate<LivingEntity> predicate = e -> true;
        @Nullable
        private IdTagMatcher idTagMatcher = null;
        @Nullable
        private TagKey<EntityType<?>> entityTypesToAvoid = null;

        public Builder(PathfinderMob goalOwner, Class<T> classToAvoid, EAIData<Integer> avoidDistanceFar, EAIData<Integer> avoidDistanceNear, EAIData<Double> farSpeed, EAIData<Double> nearSpeed, EAIData<Integer> horizontalDistance, EAIData<Integer> verticalDistance) {
            this.goalOwner = goalOwner;
            this.classToAvoid = classToAvoid;
            this.avoidDistanceFar = avoidDistanceFar;
            this.avoidDistanceNear = avoidDistanceNear;
            this.farSpeed = farSpeed;
            this.nearSpeed = nearSpeed;
            this.horizontalDistance = horizontalDistance;
            this.verticalDistance = verticalDistance;
        }

        public Builder<T> withPredicate(Predicate<LivingEntity> predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder<T> withIdTagMatcher(IdTagMatcher matcher) {
            this.idTagMatcher = matcher;
            return this;
        }

        public Builder<T> withTagToAvoid(TagKey<EntityType<?>> tag) {
            this.entityTypesToAvoid = tag;
            return this;
        }

        public EAIAvoidEntityGoal<T> build() {
            return new EAIAvoidEntityGoal(this);
        }
    }
}

