/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.data;

import insane96mcp.insanelib.util.ModNBTData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class EAIData<T> {
    public static final List<EAIData<?>> DATA = new ArrayList();
    protected final ResourceLocation id;
    protected final BiConsumer<Mob, T> onChange;
    protected final Class<T> type;

    protected EAIData(ResourceLocation id, BiConsumer<Mob, T> onChange, Class<T> type) {
        this.id = id;
        this.onChange = onChange;
        this.type = type;
    }

    public void apply(Mob mob, T value) {
        ModNBTData.put((Entity)mob, (ResourceLocation)this.id, value);
        this.onChange.accept(mob, (Mob)value);
    }

    public void changed(Mob mob) {
        if (!ModNBTData.contains((Entity)mob, (ResourceLocation)this.id)) {
            return;
        }
        this.onChange.accept(mob, (Mob)this.get((Entity)mob));
    }

    public void applyIfAbsent(Mob mob, T value) {
        if (!ModNBTData.contains((Entity)mob, (ResourceLocation)this.id)) {
            this.apply(mob, value);
        } else {
            this.onChange.accept(mob, (Mob)this.get((Entity)mob));
        }
    }

    public ResourceLocation id() {
        return this.id;
    }

    public BiConsumer<Mob, T> onChange() {
        return this.onChange;
    }

    public Class<T> type() {
        return this.type;
    }

    public static EAIData<Boolean> ofBool(ResourceLocation id) {
        return EAIData.ofBool(id, (mob, value) -> {});
    }

    public static EAIData<Integer> ofInt(ResourceLocation id) {
        return EAIData.ofInt(id, (mob, value) -> {});
    }

    public static EAIData<Double> ofDouble(ResourceLocation id) {
        return EAIData.ofDouble(id, (mob, value) -> {});
    }

    public static EAIData<String> ofString(ResourceLocation id) {
        return EAIData.ofString(id, (mob, value) -> {});
    }

    public static EAIData<Boolean> ofBool(ResourceLocation id, BiConsumer<Mob, Boolean> onChange) {
        EAIData<Boolean> data = new EAIData<Boolean>(id, onChange, Boolean.class);
        DATA.add(data);
        return data;
    }

    public static EAIData<Integer> ofInt(ResourceLocation id, BiConsumer<Mob, Integer> onChange) {
        EAIData<Integer> data = new EAIData<Integer>(id, onChange, Integer.class);
        DATA.add(data);
        return data;
    }

    public static EAIData<Double> ofDouble(ResourceLocation id, BiConsumer<Mob, Double> onChange) {
        EAIData<Double> data = new EAIData<Double>(id, onChange, Double.class);
        DATA.add(data);
        return data;
    }

    public static EAIData<String> ofString(ResourceLocation id, BiConsumer<Mob, String> onChange) {
        EAIData<String> data = new EAIData<String>(id, onChange, String.class);
        DATA.add(data);
        return data;
    }

    public static EAIData<List<String>> ofStringList(ResourceLocation id) {
        return EAIData.ofStringList(id, (mob, value) -> {});
    }

    public static EAIData<List<String>> ofStringList(ResourceLocation id, BiConsumer<Mob, List<String>> onChange) {
        EAIData<List<String>> data = new EAIData<List<String>>(id, onChange, List.class);
        DATA.add(data);
        return data;
    }

    public T get(Entity entity) {
        return (T)ModNBTData.get((Entity)entity, (ResourceLocation)this.id, this.type);
    }

    public boolean has(Entity entity) {
        return ModNBTData.contains((Entity)entity, (ResourceLocation)this.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EAIData that = (EAIData)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.onChange, that.onChange);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.onChange);
    }

    public String toString() {
        return "EAIData[id=" + String.valueOf(this.id) + ", consumer=" + String.valueOf(this.onChange) + "]";
    }

    public T parse(String input) {
        if (this.type == String.class) {
            return this.type.cast(input);
        }
        if (this.type == Boolean.class) {
            return this.type.cast(this.parseBoolean(input));
        }
        if (this.type == Integer.class) {
            return this.type.cast(Integer.parseInt(input));
        }
        if (this.type == Double.class) {
            return this.type.cast(Double.parseDouble(input));
        }
        if (this.type == List.class) {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : input.split(",")) {
                list.add(s.trim());
            }
            return this.type.cast(list);
        }
        throw new IllegalStateException("Unsupported type: " + String.valueOf(this.type));
    }

    private boolean parseBoolean(String input) {
        if (!input.equalsIgnoreCase("true") && !input.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException("Invalid boolean value: " + input);
        }
        return Boolean.parseBoolean(input);
    }

    public static <T> void apply(EAIData<T> data, Mob mob, Object value) {
        data.apply(mob, value);
    }
}

