/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.data;

import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class EAIDataEnum<T extends Enum<T>>
extends EAIData<T> {
    private final Class<T> enumType;

    private EAIDataEnum(ResourceLocation id, BiConsumer<Mob, T> onChange, Class<T> enumType) {
        super(id, onChange, enumType);
        this.enumType = enumType;
    }

    public static <E extends Enum<E>> EAIDataEnum<E> of(ResourceLocation id, Class<E> enumType) {
        return EAIDataEnum.of(id, (mob, enumValue) -> {}, enumType);
    }

    public static <E extends Enum<E>> EAIDataEnum<E> of(ResourceLocation id, BiConsumer<Mob, E> onChange, Class<E> enumType) {
        EAIDataEnum<E> data = new EAIDataEnum<E>(id, onChange, enumType);
        DATA.add(data);
        return data;
    }

    @Override
    public void apply(Mob mob, T value) {
        ModNBTData.put((Entity)mob, (ResourceLocation)this.id, (Object)((Enum)value).name());
        this.onChange.accept(mob, value);
    }

    @Override
    public T get(Entity entity) {
        if (!ModNBTData.contains((Entity)entity, (ResourceLocation)this.id)) {
            return this.getDefault();
        }
        String stored = (String)ModNBTData.get((Entity)entity, (ResourceLocation)this.id, String.class);
        try {
            return Enum.valueOf(this.enumType, stored);
        }
        catch (IllegalArgumentException e) {
            return this.getDefault();
        }
    }

    @Override
    public T parse(String input) {
        if (input == null || input.isBlank()) {
            return (T)((Enum)super.parse(input));
        }
        try {
            return Enum.valueOf(this.enumType, input);
        }
        catch (IllegalArgumentException e) {
            return (T)((Enum)super.parse(input));
        }
    }

    private T getDefault() {
        return (T)((Enum[])this.enumType.getEnumConstants())[0];
    }
}

