/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.data.mpr.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class EAIDataCondition
extends MPRCondition {
    public ResourceLocation data;
    @Nullable
    public String stringValue;
    @Nullable
    public MPRRange value;

    public EAIDataCondition(ResourceLocation data, @Nullable String stringValue, @Nullable MPRRange value, boolean inverted) {
        super(inverted);
        this.data = data;
        this.stringValue = stringValue;
        this.value = value;
    }

    protected boolean conditionCheck(LivingEntity living) {
        Optional<EAIData> optData = EAIData.DATA.stream().filter(d -> d.id().equals((Object)this.data)).findFirst();
        if (optData.isEmpty()) {
            return false;
        }
        EAIData data = optData.get();
        if (!data.has((Entity)living)) {
            return false;
        }
        Object value = data.get((Entity)living);
        if (this.value != null) {
            if (value instanceof Double) {
                Double d2 = (Double)value;
                return this.value.isBetween(living, d2.doubleValue());
            }
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                return this.value.isBetween(living, (double)i.intValue());
            }
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                return this.value.isBetween(living, b != false ? 1.0 : 0.0);
            }
        } else if (value instanceof String && this.stringValue != null) {
            return value.equals(this.stringValue);
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<EAIDataCondition>,
    JsonSerializer<EAIDataCondition> {
        public EAIDataCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            ResourceLocation data = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)jObject, (String)"data"));
            Optional<EAIData> optData = EAIData.DATA.stream().filter(d -> d.id().equals((Object)data)).findFirst();
            if (optData.isEmpty()) {
                throw new JsonParseException("Defined data does not exist: " + String.valueOf(data));
            }
            return new EAIDataCondition(data, GsonHelper.m_13851_((JsonObject)jObject, (String)"string_value", null), (MPRRange)GsonHelper.m_13845_((JsonObject)jObject, (String)"value", null, (JsonDeserializationContext)context, MPRRange.class), MPRCondition.deserializeInverted((JsonObject)jObject));
        }

        public JsonElement serialize(EAIDataCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.addProperty("data", src.data.toString());
            if (src.value != null) {
                jObject.add("value", context.serialize((Object)src.value));
            }
            if (src.stringValue != null) {
                jObject.addProperty("string_value", src.stringValue);
            }
            return src.endSerialization(jObject);
        }
    }
}

