/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.data.mpr.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

@JsonAdapter(value=Serializer.class)
public class EAIChangeDataProperty
extends MPRProperty {
    public ResourceLocation data;
    @Nullable
    public String stringValue;
    @Nullable
    public MPRRange value;

    public EAIChangeDataProperty(ResourceLocation data, @Nullable String stringValue, @Nullable MPRRange value, List<MPRCondition> conditions) {
        super(conditions);
        this.data = data;
        this.stringValue = stringValue;
        this.value = value;
    }

    public boolean apply(LivingEntity living) {
        if (!(living instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)living;
        Optional<EAIData> optData = EAIData.DATA.stream().filter(d -> d.id().equals((Object)this.data)).findFirst();
        if (optData.isEmpty()) {
            return false;
        }
        EAIData data = optData.get();
        if (this.value != null) {
            EAIData.apply(data, mob, this.value.getValue(living));
        } else if (this.stringValue != null) {
            EAIData.apply(data, mob, this.stringValue);
        }
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<EAIChangeDataProperty>,
    JsonSerializer<EAIChangeDataProperty> {
        public EAIChangeDataProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            ResourceLocation data = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)jObject, (String)"data"));
            Optional<EAIData> optData = EAIData.DATA.stream().filter(d -> d.id().equals((Object)data)).findFirst();
            if (optData.isEmpty()) {
                throw new JsonParseException("Defined data does not exist: " + String.valueOf(data));
            }
            return new EAIChangeDataProperty(data, GsonHelper.m_13851_((JsonObject)jObject, (String)"string_value", null), (MPRRange)GsonHelper.m_13845_((JsonObject)jObject, (String)"value", null, (JsonDeserializationContext)context, MPRRange.class), MPRCondition.deserializeConditions((JsonObject)jObject, (JsonDeserializationContext)context));
        }

        public JsonElement serialize(EAIChangeDataProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.addProperty("data", src.data.toString());
            if (src.value != null) {
                jObject.add("value", context.serialize((Object)src.value));
            }
            if (src.stringValue != null) {
                jObject.addProperty("string_value", src.stringValue);
            }
            return src.endSerialization(jObject, context);
        }
    }
}

