/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.mixin.accessors.PanicGoalAccessor;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:animal", description="Make animals panic when one is attacked. Only entity types in `enhancedai:animal/can_panic` tag will be affected by this feature.")
public class AnimalsPanic
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("animal/can_panic"));
    @Config(min=1.0, description="Range at which an animal alerts other animals to panic/attack.")
    public static Integer fleeRange = 16;
    @Config(description="The flee range will be this value if the animal can see the other animals")
    public static Integer fleeRangeIfSeen = 32;
    public static EAIData<Double> PANIC_SPEED_MODIFIER;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        PANIC_SPEED_MODIFIER = EAIData.ofDouble(this.createDataKey("panic_speed_mod"), (mob, panicSpeedModifier) -> GoalHelper.getGoal(mob.f_21345_, PanicGoal.class).ifPresent(goal -> ((PanicGoalAccessor)goal).setSpeedModifier((double)panicSpeedModifier)));
    }

    @SubscribeEvent
    public void onAttacked(LivingDamageEvent event) {
        LivingEntity attacker;
        Animal animal;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Animal)) break block2;
                animal = (Animal)livingEntity;
                livingEntity = event.getSource().m_7639_();
                if (!(livingEntity instanceof LivingEntity)) break block2;
                attacker = livingEntity;
                if (animal.m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) break block3;
            }
            return;
        }
        animal.m_9236_().m_45971_(Animal.class, TargetingConditions.m_148353_().m_148355_(), (LivingEntity)animal, animal.m_20191_().m_82400_((double)fleeRangeIfSeen.intValue())).stream().filter(otherAnimal -> {
            if (!otherAnimal.m_6095_().equals(animal.m_6095_())) {
                return false;
            }
            if (!otherAnimal.m_21574_().m_148306_((Entity)animal) && otherAnimal.m_20280_((Entity)animal) > (double)(fleeRange * fleeRange)) {
                return false;
            }
            return otherAnimal.m_20270_((Entity)animal) < (float)fleeRangeIfSeen.intValue();
        }).forEach(nearbyAnimal -> nearbyAnimal.m_6703_(attacker));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Animal animal;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal) || !(animal = (Animal)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        GoalHelper.getGoal(animal.f_21345_, PanicGoal.class).ifPresent(goal -> PANIC_SPEED_MODIFIER.applyIfAbsent((Mob)animal, ((PanicGoalAccessor)goal).getSpeedModifier()));
    }
}

