/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:animal", description="Makes animals not tempted by food. Use the entity type tag enhancedai:animal/can_ignore_food_temptation to change animals.")
public class NotTemptedAnimals
extends Feature {
    public static final TagKey<EntityType<?>> CAN_IGNORE_FOOD_TEMPTATION = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("animal/can_ignore_food_temptation"));
    public static ResourceLocation NOT_TEMPTED;
    @Config(min=0.0, max=1.0, description="Animals have this percentage chance to not be temped by food.")
    public static Double notTemptedChance;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        NOT_TEMPTED = this.createDataKey("not_tempted");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        boolean notTempted = NBTUtils.getBooleanOrPutDefault((Entity)animal, NOT_TEMPTED, animal.m_6095_().m_204039_(CAN_IGNORE_FOOD_TEMPTATION) && animal.m_217043_().m_188500_() < notTemptedChance);
        if (notTempted) {
            GoalHelper.removeGoal(animal.f_21345_, TemptGoal.class);
        }
    }

    static {
        notTemptedChance = 0.5;
    }
}

