/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.blaze;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.blaze.EAIBlazeAttackGoal;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:blaze", description="Make blazes fire faster/more fireballs. Only mobs in enhancedai:blaze/change_attack entity type tag are affected by this feature.")
public class BlazeAttack
extends Feature {
    public static final TagKey<EntityType<?>> CHANGE_ATTACK = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("blaze_attack/change_attack"));
    @Config(min=1.0, max=300.0, description="How many ticks pass between shooting fireballs. Vanilla is 6")
    public static MinMax timeBetweenFireballs = new MinMax(4.0, 10.0);
    @Config(min=1.0, max=64.0, description="How many fireballs blazes shoots. Vanilla is 3")
    public static MinMax fireballsShot = new MinMax(2.0, 6.0);
    @Config(min=1.0, max=600.0, description="Time (in ticks) taken by the blaze to recharge (before setting himself on fire). Vanilla is 100")
    public static MinMax rechargeTime = new MinMax(60.0, 120.0);
    @Config(min=1.0, max=600.0, description="Time (in ticks) taken by the blaze to charge (while on fire before shooting fireballs). Vanilla is 60")
    public static MinMax chargeTime = new MinMax(30.0, 80.0);
    @Config(min=1.0, max=8.0, description="How many fireballs are shot per shot. Vanilla is 1")
    public static MinMax fireballsPerShot = new MinMax(1.0, 2.0);
    @Config(min=-1.0, max=32.0, description="The higher the more spread up shots will be. Setting both to -1 will use the vanilla behaviour (farther = more inaccuracy)")
    public static MinMax inaccuracy = new MinMax(1.0, 3.0);
    public static EAIData<Integer> TIME_BETWEEN_FIREBALLS;
    public static EAIData<Integer> FIREBALLS_SHOT;
    public static EAIData<Integer> RECHARGE_TIME;
    public static EAIData<Integer> CHARGE_TIME;
    public static EAIData<Integer> FIREBALLS_PER_SHOT;
    public static EAIData<Integer> INACCURACY;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        TIME_BETWEEN_FIREBALLS = EAIData.ofInt(this.createDataKey("time_between_fireballs"));
        FIREBALLS_SHOT = EAIData.ofInt(this.createDataKey("fireballs_shot"));
        RECHARGE_TIME = EAIData.ofInt(this.createDataKey("recharge_time"));
        CHARGE_TIME = EAIData.ofInt(this.createDataKey("charge_time"));
        FIREBALLS_PER_SHOT = EAIData.ofInt(this.createDataKey("fireballs_per_shot"));
        INACCURACY = EAIData.ofInt(this.createDataKey("inaccuracy"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Blaze blaze;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Blaze) || !(blaze = (Blaze)entity).m_6095_().m_204039_(CHANGE_ATTACK)) {
            return;
        }
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        blaze.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof Blaze.BlazeAttackGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)blaze.f_21345_).m_25363_(arg_0));
        blaze.f_21345_.m_25352_(4, (Goal)new EAIBlazeAttackGoal(blaze));
        TIME_BETWEEN_FIREBALLS.applyIfAbsent((Mob)blaze, timeBetweenFireballs.getIntRandBetween(blaze.m_217043_()));
        FIREBALLS_SHOT.applyIfAbsent((Mob)blaze, fireballsShot.getIntRandBetween(blaze.m_217043_()));
        RECHARGE_TIME.applyIfAbsent((Mob)blaze, rechargeTime.getIntRandBetween(blaze.m_217043_()));
        CHARGE_TIME.applyIfAbsent((Mob)blaze, chargeTime.getIntRandBetween(blaze.m_217043_()));
        FIREBALLS_PER_SHOT.applyIfAbsent((Mob)blaze, fireballsPerShot.getIntRandBetween(blaze.m_217043_()));
        INACCURACY.applyIfAbsent((Mob)blaze, inaccuracy.getIntRandBetween(blaze.m_217043_()));
    }
}

