/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.bugs.silverfish.mergewithstone;

import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.bugs.silverfish.mergewithstone.EAISilverfishMergeWithStoneGoal;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:bugs", description="Let them swarm. This also changes the Merge With stone goal to have 1.5 seconds cooldown before trying to merge, to prevent them from instantly getting into stone without having the chance to target someone.")
public class SilverfishMergeWithStone
extends Feature {
    @Config(min=1.0, description="Chance (1 in x every 2 ticks) for a silverfish to merge with a stone block. Vanilla is 10.")
    public static Integer chanceToMergeWithStone = 10;
    public static EAIData<Integer> CHANCE_TO_MERGE_WITH_STONE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CHANCE_TO_MERGE_WITH_STONE = EAIData.ofInt(this.createDataKey("chance_to_merge_with_stone"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Silverfish)) {
            return;
        }
        Silverfish silverfish = (Silverfish)entity;
        GoalHelper.removeGoal(silverfish.f_21345_, Silverfish.SilverfishMergeWithStoneGoal.class);
        silverfish.f_21345_.m_25352_(5, (Goal)new EAISilverfishMergeWithStoneGoal(silverfish));
        CHANCE_TO_MERGE_WITH_STONE.applyIfAbsent((Mob)silverfish, chanceToMergeWithStone);
    }
}

