/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.drowned;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:drowned", description="Replaces the drowned swim up goal with a better one, allowing them to leap out of the water. Only entity types in the enhancedai:drowned/change_swim_up tag are affected by this feature.")
public class BetterDrownedSwimUp
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("drowned/change_swim_up"));

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Drowned drowned;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Drowned) || !(drowned = (Drowned)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        drowned.f_21345_.m_262460_(goal -> goal instanceof Drowned.DrownedSwimUpGoal);
        drowned.f_21345_.m_25352_(6, (Goal)new DrownedSwimUpGoal(drowned, 1.0, drowned.m_9236_().m_5736_()));
    }

    static class DrownedSwimUpGoal
    extends Goal {
        private final Drowned drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;
        private int leapTick = 0;

        public DrownedSwimUpGoal(Drowned pDrowned, double pSpeedModifier, int pSeaLevel) {
            this.drowned = pDrowned;
            this.speedModifier = pSpeedModifier;
            this.seaLevel = pSeaLevel;
        }

        public boolean m_8036_() {
            return this.drowned.m_20069_() && this.drowned.m_20186_() < (double)this.seaLevel;
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck && this.leapTick > 0;
        }

        public void m_8037_() {
            LivingEntity target;
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel + 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
            if (--this.leapTick <= 0 && this.drowned.m_20186_() >= (double)(this.seaLevel - 1) && (target = this.drowned.m_5448_()) != null && !target.m_20069_() && target.m_20096_()) {
                Vec3 dir = new Vec3(target.m_20185_() - this.drowned.m_20185_(), target.m_20186_() - this.drowned.m_20186_(), target.m_20189_() - this.drowned.m_20189_()).m_82541_();
                this.drowned.m_20256_(new Vec3(dir.f_82479_ * 0.5, 0.4, dir.f_82481_ * 0.5));
                this.drowned.m_21573_().m_26573_();
            }
        }

        public void m_8056_() {
            this.drowned.m_32398_(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.m_32398_(false);
            this.leapTick = this.m_183277_(10);
        }

        protected boolean closeToNextPos() {
            Path path = this.drowned.m_21573_().m_26570_();
            if (path == null) {
                return false;
            }
            BlockPos blockpos = path.m_77406_();
            double d0 = this.drowned.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
            return d0 < 4.0;
        }
    }
}

