/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.drowned.drowningtargets;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.MeleeAttacking;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.MCUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs pick up targets to drown them. Only entity types in the enhancedai:mobs/drowning_targets tag are affected by this feature.")
public class DrowningTargets
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/drowning_targets"));
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("8993201c-00fc-489e-a18c-1ebc94ba983f");
    public static EAIData<Boolean> DROWNING_TARGETS;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        DROWNING_TARGETS = EAIData.ofBool(this.createDataKey("drowning_targets"), (mob, drowningTargets) -> {
            if (!(mob instanceof PathfinderMob)) {
                return;
            }
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            mob.f_21345_.m_262460_(goal -> goal instanceof DrownTargetGoal);
            if (drowningTargets.booleanValue()) {
                mob.f_21345_.m_25352_(2, (Goal)new DrownTargetGoal(pathfinderMob, 1.0, pathfinderMob.m_9236_().m_5736_()));
            }
        });
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        PathfinderMob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof PathfinderMob) || !(mob = (PathfinderMob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        DROWNING_TARGETS.applyIfAbsent((Mob)mob, true);
    }

    @SubscribeEvent
    public void onDismount(EntityMountEvent event) {
        block3: {
            block2: {
                Player player;
                Entity entity;
                if (!this.isEnabled() || !event.isDismounting() || !((entity = event.getEntityBeingMounted()) instanceof Drowned)) break block2;
                Drowned drowned = (Drowned)entity;
                if (event.getEntityBeingMounted().m_6084_() && (entity = event.getEntityMounting()) instanceof Player && !(player = (Player)entity).m_7500_() && player.m_6084_()) break block3;
            }
            return;
        }
        event.setCanceled(true);
    }

    static class DrownTargetGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speedModifier;
        private final int seaLevel;

        public DrownTargetGoal(PathfinderMob pDrowned, double pSpeedModifier, int pSeaLevel) {
            this.mob = pDrowned;
            this.speedModifier = pSpeedModifier;
            this.seaLevel = pSeaLevel;
        }

        public boolean m_8036_() {
            return this.mob.m_20069_() && this.mob.m_20186_() < (double)this.seaLevel && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_5448_().m_20146_() <= 100 && MeleeAttacking.isWithinMeleeAttackRange((LivingEntity)this.mob, this.mob.m_5448_()) && this.mob.m_142582_((Entity)this.mob.m_5448_());
        }

        public boolean m_8045_() {
            Optional passenger0 = this.mob.m_20197_().stream().findFirst();
            return passenger0.isPresent() && passenger0.get() == this.mob.m_5448_() && ((Entity)passenger0.get()).m_6084_();
        }

        public void m_8037_() {
            if (this.mob.m_20186_() < (double)(this.seaLevel + 1) && (this.mob.m_21573_().m_26571_() || this.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)8, (int)16, (Vec3)new Vec3(this.mob.m_20185_(), (double)this.mob.m_9236_().m_141937_(), this.mob.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    return;
                }
                this.mob.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            if (this.mob.m_5448_().m_20159_()) {
                this.mob.m_5448_().m_8127_();
            }
            this.mob.m_5448_().m_20329_((Entity)this.mob);
            MCUtils.applyModifier((LivingEntity)this.mob, (Attribute)Attributes.f_22281_, (UUID)ATTACK_DAMAGE_UUID, (String)"Drowning Targets", (double)-1.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }

        public void m_8041_() {
            this.mob.m_21051_(Attributes.f_22281_).m_22120_(ATTACK_DAMAGE_UUID);
        }

        protected boolean closeToNextPos() {
            Path path = this.mob.m_21573_().m_26570_();
            if (path == null) {
                return false;
            }
            BlockPos blockpos = path.m_77406_();
            double d0 = this.mob.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
            return d0 < 4.0;
        }
    }
}

