/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.illager.shoot;

import insane96mcp.enhancedai.modules.illager.shoot.PillagerShoot;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class EAIPillagerAttackGoal
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final Pillager mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public EAIPillagerAttackGoal(Pillager pMob, double pSpeedModifier) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.mob.m_21573_().m_26571_();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            this.mob.m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean isOutOfRangeOrCantSee;
        boolean hasSeenRecently;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return;
        }
        boolean hasLineOfSight = this.mob.m_21574_().m_148306_((Entity)livingentity);
        boolean bl = hasSeenRecently = this.seeTime > 0;
        if (hasLineOfSight != hasSeenRecently) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        double distance = this.mob.m_20280_((Entity)livingentity);
        double attackRadius = PillagerShoot.SHOOTING_RANGE.get((Entity)this.mob).intValue();
        boolean bl2 = isOutOfRangeOrCantSee = (distance > attackRadius * attackRadius || this.seeTime < 5) && this.attackDelay == 0;
        if (isOutOfRangeOrCantSee) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            this.updatePathDelay = 0;
        }
        this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        if (this.crossbowState == CrossbowState.UNCHARGED && !isOutOfRangeOrCantSee) {
            Entity entity;
            this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, item -> item instanceof CrossbowItem));
            this.crossbowState = CrossbowState.CHARGING;
            this.mob.m_6136_(true);
            if (!this.mob.m_20159_() && (entity = PillagerShoot.mightHitAnAlly(this.mob, distance)) != null) {
                PillagerShoot.tryReposition(this.mob, entity, 2);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack crossbow;
            int useTicks;
            if (!this.mob.m_6117_()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((useTicks = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(crossbow = this.mob.m_21211_()))) {
                this.mob.m_21253_();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = PillagerShoot.SHOOTING_COOLDOWN.get((Entity)this.mob);
                this.mob.m_6136_(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            if (--this.attackDelay <= 0) {
                Entity entity = PillagerShoot.mightHitAnAlly(this.mob, distance);
                if (entity != null) {
                    this.attackDelay = 20;
                    PillagerShoot.tryReposition(this.mob, entity, 2);
                } else {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && hasLineOfSight) {
            this.performCrossbowAttack();
            ItemStack crossbow = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, item -> item instanceof CrossbowItem));
            CrossbowItem.m_40884_((ItemStack)crossbow, (boolean)false);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    private void performCrossbowAttack() {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, item -> item instanceof CrossbowItem);
        ItemStack itemstack = this.mob.m_21120_(interactionhand);
        if (this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            EAIPillagerAttackGoal.performShooting(this.mob.m_9236_(), (LivingEntity)this.mob, interactionhand, itemstack, PillagerShoot.INACCURACY.get((Entity)this.mob).floatValue());
        }
        this.mob.m_5847_();
    }

    public static void performShooting(Level pLevel, LivingEntity pShooter, InteractionHand pUsedHand, ItemStack crossbowStack, float inaccuracy) {
        List list = CrossbowItem.m_40941_((ItemStack)crossbowStack);
        float[] afloat = EAIPillagerAttackGoal.getShotPitches(pShooter.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = (ItemStack)list.get(i);
            boolean bl = flag = pShooter instanceof Player && ((Player)pShooter).m_150110_().f_35937_;
            if (itemstack.m_41619_()) continue;
            if (i == 0) {
                EAIPillagerAttackGoal.shootProjectile(pLevel, pShooter, pUsedHand, crossbowStack, itemstack, afloat[i], flag, inaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                EAIPillagerAttackGoal.shootProjectile(pLevel, pShooter, pUsedHand, crossbowStack, itemstack, afloat[i], flag, inaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            EAIPillagerAttackGoal.shootProjectile(pLevel, pShooter, pUsedHand, crossbowStack, itemstack, afloat[i], flag, inaccuracy, 10.0f);
        }
        CrossbowItem.m_40905_((Level)pLevel, (LivingEntity)pShooter, (ItemStack)crossbowStack);
    }

    private static float[] getShotPitches(RandomSource pRandom) {
        boolean flag = pRandom.m_188499_();
        return new float[]{1.0f, EAIPillagerAttackGoal.getRandomShotPitch(flag, pRandom), EAIPillagerAttackGoal.getRandomShotPitch(!flag, pRandom)};
    }

    private static float getRandomShotPitch(boolean pIsHighPitched, RandomSource pRandom) {
        float f = pIsHighPitched ? 0.63f : 0.43f;
        return 1.0f / (pRandom.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void shootProjectile(Level pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pCrossbowStack, ItemStack pAmmoStack, float pSoundPitch, boolean pIsCreativeMode, float inaccuracy, float pProjectileAngle) {
        if (!pLevel.f_46443_) {
            AbstractArrow projectile;
            boolean isShootingFirework = pAmmoStack.m_150930_(Items.f_42688_);
            if (isShootingFirework) {
                projectile = new FireworkRocketEntity(pLevel, pAmmoStack, (Entity)pShooter, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.15f, pShooter.m_20189_(), true);
            } else {
                projectile = CrossbowItem.m_40914_((Level)pLevel, (LivingEntity)pShooter, (ItemStack)pCrossbowStack, (ItemStack)pAmmoStack);
                if (pIsCreativeMode || pProjectileAngle != 0.0f) {
                    projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (pShooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob mob = (CrossbowAttackMob)pShooter;
                EAIPillagerAttackGoal.attackEntityWithRangedAttack(pShooter, mob.m_5448_(), pCrossbowStack, (Projectile)projectile, pProjectileAngle, inaccuracy);
            }
            pCrossbowStack.m_41622_(isShootingFirework ? 3 : 1, pShooter, entity -> entity.m_21190_(pHand));
            pLevel.m_7967_((Entity)projectile);
            pLevel.m_6263_(null, pShooter.m_20185_(), pShooter.m_20186_(), pShooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    protected static void attackEntityWithRangedAttack(LivingEntity livingEntity, LivingEntity target, ItemStack crossbow, Projectile projectile, float angle, float inaccuracy) {
        double distance = livingEntity.m_20270_((Entity)target);
        float distanceY = (float)(target.m_20186_() - livingEntity.m_20186_());
        float dirX = (float)(target.m_20185_() - livingEntity.m_20185_());
        float dirZ = (float)(target.m_20189_() - livingEntity.m_20189_());
        float distanceXZ = (float)Math.sqrt(dirX * dirX + dirZ * dirZ);
        float yPos = (float)target.m_20227_(0.0);
        yPos += target.m_20192_() * 0.5f;
        if (distanceXZ != 0.0f) {
            yPos += distanceY / distanceXZ;
        }
        float dirY = (float)((double)yPos - projectile.m_20186_());
        Vector3f shootRotation = ((CrossbowAttackMob)livingEntity).m_252851_(livingEntity, new Vec3((double)dirX, (double)(dirY + distanceXZ * 0.2f), (double)dirZ), angle);
        projectile.m_6686_((double)shootRotation.x(), (double)shootRotation.y(), (double)shootRotation.z(), 1.1f + (float)distance / 32.0f + (float)Math.max((double)distanceY / 48.0, 0.0), inaccuracy);
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

