/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAIAvoidTargetGoal;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Make mobs flee from the target. Use the enhancedai:mobs/can_flee entity type tag to add/remove entities that are affected by this feature. Mobs like animals have they're own feature for fleeing the target due to having different conditions.")
public class FleeTarget
extends Feature {
    public static final TagKey<EntityType<?>> CAN_FLEE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_flee"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to spawn with the ability to avoid the target")
    public static Double avoidTargetChance = 0.5;
    @Config(min=0.0, max=1.0, description="Chance for a mob to be able to attack while running from a target. This only works for ranged mobs")
    public static Double attackWhenAvoidingChance = 0.5;
    @Config(min=0.0, description="Distance from the target that will make the mob run away.")
    public static Integer fleeDistanceFar = 13;
    @Config(min=0.0, description="Distance from the target that counts as near and will make the mob run away faster.")
    public static Integer fleeDistanceNear = 7;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the mob avoids the target and it's farther than 'Flee Distance Near' blocks from him.")
    public static Double fleeSpeedFar = 1.0;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the mob avoids the target and it's within 'Flee Distance Near' blocks from him.")
    public static Double fleeSpeedNear = 1.1;
    public static EAIData<Boolean> AVOID_TARGET;
    public static EAIData<Boolean> ATTACK_WHEN_AVOIDING;
    public static EAIData<Integer> FLEE_DISTANCE_FAR;
    public static EAIData<Integer> FLEE_DISTANCE_NEAR;
    public static EAIData<Double> FLEE_SPEED_FAR;
    public static EAIData<Double> FLEE_SPEED_NEAR;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        AVOID_TARGET = EAIData.ofBool(this.createDataKey("avoid_target"), (mob, avoidTarget) -> {
            if (!(mob instanceof PathfinderMob)) {
                return;
            }
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            GoalHelper.removeGoal(mob.f_21345_, EAIAvoidTargetGoal.class);
            if (avoidTarget.booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new EAIAvoidTargetGoal(pathfinderMob, FLEE_DISTANCE_FAR, FLEE_DISTANCE_NEAR, FLEE_SPEED_FAR, FLEE_SPEED_NEAR));
            }
            ATTACK_WHEN_AVOIDING.changed((Mob)mob);
        });
        ATTACK_WHEN_AVOIDING = EAIData.ofBool(this.createDataKey("attack_when_avoiding"), (mob, attackWhenAvoiding) -> GoalHelper.getGoal(mob.f_21345_, EAIAvoidTargetGoal.class).ifPresent(goal -> goal.setAttackWhenRunning((boolean)attackWhenAvoiding)));
        FLEE_DISTANCE_FAR = EAIData.ofInt(this.createDataKey("flee_distance_far"));
        FLEE_DISTANCE_NEAR = EAIData.ofInt(this.createDataKey("flee_distance_near"));
        FLEE_SPEED_FAR = EAIData.ofDouble(this.createDataKey("flee_speed_far"));
        FLEE_SPEED_NEAR = EAIData.ofDouble(this.createDataKey("flee_speed_near"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_FLEE)) {
            return;
        }
        AVOID_TARGET.applyIfAbsent(mob, mob.m_217043_().m_188500_() < avoidTargetChance);
        ATTACK_WHEN_AVOIDING.applyIfAbsent(mob, mob.m_217043_().m_188500_() < attackWhenAvoidingChance);
        FLEE_DISTANCE_FAR.applyIfAbsent(mob, fleeDistanceFar);
        FLEE_DISTANCE_NEAR.applyIfAbsent(mob, fleeDistanceNear);
        FLEE_SPEED_FAR.applyIfAbsent(mob, fleeSpeedFar);
        FLEE_SPEED_NEAR.applyIfAbsent(mob, fleeSpeedNear);
    }
}

