/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", enabledByDefault=false, description="Endermen will make the player's item fall from his hands. Add/remove mobs via the enhancedai:mobs/can_disrupt_item entity type tag")
public class ItemDisruption
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_disrupt_item"));
    @Config(min=0.0, max=1.0)
    public static Difficulty chance = new Difficulty(0.25, 0.25, 0.35);
    @Config(description="Cooldown (in ticks) before being able to use the ability again.")
    public static Integer cooldown = 200;
    public static ResourceLocation LAST_DISRUPTION;
    public static EAIData<Double> CHANCE;
    public static EAIData<Integer> COOLDOWN;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        LAST_DISRUPTION = this.createDataKey("last_disruption");
        CHANCE = EAIData.ofDouble(this.createDataKey("chance"));
        COOLDOWN = EAIData.ofInt(this.createDataKey("cooldown"));
    }

    @SubscribeEvent
    public void onHit(LivingDamageEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity;
        block9: {
            block8: {
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) break block8;
                player = (ServerPlayer)livingEntity;
                livingEntity = event.getSource().m_7640_();
                if (livingEntity instanceof Mob) break block9;
            }
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().m_46467_() - (Long)ModNBTData.get((Entity)mob, (ResourceLocation)LAST_DISRUPTION, Long.class) < (long)COOLDOWN.get((Entity)mob).intValue()) {
            return;
        }
        if ((double)mob.m_217043_().m_188501_() >= CHANCE.get((Entity)mob)) {
            return;
        }
        ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandItem = player.m_21120_(InteractionHand.OFF_HAND);
        if (mainHandItem.m_41619_() && offHandItem.m_41619_()) {
            return;
        }
        ItemStack stack = !mainHandItem.m_41619_() ? (!offHandItem.m_41619_() ? (mob.m_217043_().m_188499_() ? mainHandItem.m_41777_() : offHandItem.m_41777_()) : mainHandItem.m_41777_()) : offHandItem.m_41777_();
        event.setCanceled(true);
        player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 0.5f);
        Inventory inventory = player.m_150109_();
        int slot = inventory.m_36030_(stack);
        if (slot == -1) {
            slot = 40;
        }
        inventory.m_7407_(slot, stack.m_41613_());
        if (player.m_21211_() == stack && stack.m_41613_() == 1) {
            player.m_5810_();
        }
        player.f_36096_.m_182417_((Container)inventory, slot).ifPresent(i -> {
            player.f_36096_.m_150404_(i, inventory.m_8020_(i));
            player.f_36096_.m_150429_();
        });
        ItemEntity itementity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), stack);
        itementity.m_32010_(30);
        mob.m_9236_().m_7967_((Entity)itementity);
        ModNBTData.put((Entity)mob, (ResourceLocation)LAST_DISRUPTION, (Object)mob.m_9236_().m_46467_());
    }

    @SubscribeEvent
    public void onJoinLevelEvent(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        CHANCE.applyIfAbsent(mob, chance.getByDifficulty(mob.m_9236_()));
        COOLDOWN.applyIfAbsent(mob, cooldown);
    }
}

