/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Gives mobs a chance to negate damage when equipped with a shield. Only entity types in `enhancedai:mobs/can_equip_shield` tag will be equipped a shield.")
public class Shielding
extends JsonFeature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_equip_shield"));
    public static final List<IdTagValue> DEFAULT_SHIELD_BLOCK_CHANCE = List.of(IdTagValue.newId((String)"minecraft:shield", (double)0.2), IdTagValue.newId((String)"shieldsplus:wooden_shield", (double)0.1), IdTagValue.newId((String)"shieldsplus:stone_shield", (double)0.15), IdTagValue.newId((String)"shieldsplus:iron_shield", (double)0.2), IdTagValue.newId((String)"shieldsplus:golden_shield", (double)0.1), IdTagValue.newId((String)"shieldsplus:diamond_shield", (double)0.3), IdTagValue.newId((String)"shieldsplus:netherite_shield", (double)0.35), IdTagValue.newId((String)"iguanatweaksreborn:copper_shield", (double)0.15));
    public static final List<IdTagValue> shieldBlockChance = new ArrayList<IdTagValue>();
    @Config
    public static double chanceToEquip = 0.08;
    public static ResourceLocation HAS_SHIELD_BEEN_GIVEN;
    public static ResourceLocation LAST_HURT_BY_AXE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        HAS_SHIELD_BEEN_GIVEN = this.createDataKey("has_shield_been_given");
        LAST_HURT_BY_AXE = this.createDataKey("last_hurt_by_axe");
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("shield_block_chance.json", shieldBlockChance, DEFAULT_SHIELD_BLOCK_CHANCE, IdTagValue.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/enhancedai";
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Mob) || ((Boolean)ModNBTData.get((Entity)(mob = (Mob)entity), (ResourceLocation)HAS_SHIELD_BEEN_GIVEN, Boolean.class)).booleanValue() || mob.m_9236_().f_46443_ || !mob.m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        if (mob.m_217043_().m_188500_() < chanceToEquip) {
            mob.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
        ModNBTData.put((Entity)mob, (ResourceLocation)HAS_SHIELD_BEEN_GIVEN, (Object)true);
    }

    @SubscribeEvent
    public void onMobAttacked(LivingAttackEvent event) {
        LivingEntity attacker;
        LivingEntity attacked;
        block10: {
            block9: {
                Entity entity;
                attacked = event.getEntity();
                if (!this.isEnabled() || event.getSource().m_269533_(DamageTypeTags.f_276146_) || !(event.getEntity() instanceof Mob) || !((entity = event.getSource().m_7640_()) instanceof LivingEntity)) break block9;
                attacker = (LivingEntity)entity;
                if (!attacked.m_9236_().f_46443_) break block10;
            }
            return;
        }
        long lastHurtByAxe = (Long)ModNBTData.get((Entity)attacked, (ResourceLocation)LAST_HURT_BY_AXE, Long.class);
        if (lastHurtByAxe > 0L && attacked.m_9236_().m_46467_() - lastHurtByAxe < 32L) {
            return;
        }
        float chance = 0.0f;
        ItemStack offHandItem = attacked.m_21206_();
        for (IdTagValue shieldChance : shieldBlockChance) {
            if (!shieldChance.id.matchesItem(offHandItem)) continue;
            chance = (float)shieldChance.value;
            break;
        }
        if (chance == 0.0f) {
            return;
        }
        if (attacked.m_217043_().m_188500_() < (double)chance) {
            event.setCanceled(true);
            offHandItem.m_220157_((int)event.getAmount(), attacked.m_217043_(), null);
            if (attacker.m_21205_().m_204117_(ItemTags.f_271207_)) {
                ModNBTData.put((Entity)attacked, (ResourceLocation)LAST_HURT_BY_AXE, (Object)attacked.m_9236_().m_46467_());
                attacked.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + attacked.m_9236_().f_46441_.m_188501_() * 0.4f);
            } else {
                attacked.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + attacked.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }
}

