/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes drowned swim speed based off swim speed attribute instead of movement speed.")
public class Swimmers
extends Feature {
    public static final TagKey<EntityType<?>> SWIM_SPEED_MULTIPLIER_AFFECTED = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/swim_speed_multiplier"));
    final UUID UUID_SWIM_SPEED_MULTIPLIER = UUID.fromString("ba2adf05-2438-4d1f-8165-89173f0a1eae");
    @Config(min=0.0, max=4.0, description="Multiplier for the swim speed of drowned. Note that the swim speed is also changed by the MPR Data Pack feature. Set to 0 to disable the multiplier.")
    public static Double drowned$swimSpeedMultiplier = 0.3;
    @Config
    public static Boolean drowned$breaching = true;
    @Config(description="Vanilla is 0.01")
    public static Double fishSwimSpeed = 0.025;

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity())) {
            return;
        }
        if (drowned$swimSpeedMultiplier > 0.0 && (entity = event.getEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6095_().m_204039_(SWIM_SPEED_MULTIPLIER_AFFECTED)) {
            MCUtils.applyModifier((LivingEntity)livingEntity, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)this.UUID_SWIM_SPEED_MULTIPLIER, (String)"Enhanced AI Drowned Swim Speed Multiplier", (double)(drowned$swimSpeedMultiplier - 1.0), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (drowned$breaching.booleanValue() && (entity = event.getEntity()) instanceof Drowned) {
            Drowned drowned = (Drowned)entity;
            ((SwimNodeEvaluator)drowned.f_32340_.m_26575_()).f_77455_ = true;
        }
    }

    public static float fishSwimSpeed(float original) {
        return !Feature.isEnabled(Swimmers.class) ? original : fishSwimSpeed.floatValue();
    }
}

