/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.blindnessaffected;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs follow range actually affected by blindness effect. Only entity types in `enhancedai:mobs/blindness_range_multiplier` tag will be affected by this.")
public class ActualBlindness
extends Feature {
    public static final TagKey<EntityType<?>> BLINDNESS_RANGE_MULTIPLIER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/blindness_range_multiplier"));
    public static final UUID BLINDNESS_FOLLOW_RANGE_UUID = UUID.fromString("b90bdf38-1c2a-4cb2-a85e-8214618e6cf0");
    @Config(min=0.0, max=1.0, description="Follow range is multiplied by this value if the mob has blindness.")
    public static Double blindnessRangeMultiplier = 0.15;
    public static EAIData<Double> BLINDNESS_RANGE_MULTIPLIER_DATA;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        BLINDNESS_RANGE_MULTIPLIER_DATA = EAIData.ofDouble(this.createDataKey("blindness_range_multiplier"));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        this.processBlindnessRangeMultiplier(mob);
    }

    private void processBlindnessRangeMultiplier(Mob mob) {
        if (!mob.m_6095_().m_204039_(BLINDNESS_RANGE_MULTIPLIER)) {
            return;
        }
        BLINDNESS_RANGE_MULTIPLIER_DATA.applyIfAbsent(mob, blindnessRangeMultiplier);
    }

    @SubscribeEvent
    public void onTargetDistanceMultiplier(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        if (!(this.isEnabled() && BLINDNESS_RANGE_MULTIPLIER_DATA.has(event.getLookingEntity()) && (entity = event.getLookingEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19610_))) {
            return;
        }
        event.modifyVisibility(BLINDNESS_RANGE_MULTIPLIER_DATA.get((Entity)livingEntity).doubleValue());
    }

    @SubscribeEvent
    public void onBlindnessApply(MobEffectEvent.Added event) {
        if (!this.isEnabled() || event.getEffectInstance().m_19544_() != MobEffects.f_19610_ || !BLINDNESS_RANGE_MULTIPLIER_DATA.has((Entity)event.getEntity())) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)event.getEntity(), (Attribute)Attributes.f_22277_, (UUID)BLINDNESS_FOLLOW_RANGE_UUID, (String)"Enhanced AI Blindness Multiplier", (double)(BLINDNESS_RANGE_MULTIPLIER_DATA.get((Entity)event.getEntity()) - 1.0), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)true);
    }

    @SubscribeEvent
    public void onBlindnessRemove(MobEffectEvent.Remove event) {
        if (!this.isEnabled() || event.getEffectInstance() == null || event.getEffectInstance().m_19544_() != MobEffects.f_19610_ || event.getEntity().m_21051_(Attributes.f_22277_) == null) {
            return;
        }
        event.getEntity().m_21051_(Attributes.f_22277_).m_22120_(BLINDNESS_FOLLOW_RANGE_UUID);
    }
}

