/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.breakanger;

import insane96mcp.enhancedai.modules.mobs.breakanger.BreakAngerConfig;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Make mobs angry when a block is broken. Check the mod's config folder Mobs/Break Anger/break_anger_config.json to change blocks and entities triggered.")
public class BreakAnger
extends JsonFeature {
    public static final List<BreakAngerConfig> ANGERING_LIST_DEFAULT = List.of(new BreakAngerConfig(IdTagMatcher.newTag((String)"forge:ores/quartz"), IdTagMatcher.newId((String)"minecraft:zombified_piglin"), 32.0, false));
    public static final List<BreakAngerConfig> angeringList = new ArrayList<BreakAngerConfig>();

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("break_anger_config.json", angeringList, ANGERING_LIST_DEFAULT, BreakAngerConfig.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/enhancedai";
    }

    @SubscribeEvent
    public void onBlockDestroyed(BlockEvent.BreakEvent event) {
        Object object;
        if (!this.isEnabled() || !((object = event.getPlayer()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)object;
        for (BreakAngerConfig breakAngerConfig : angeringList) {
            List entities = player.m_9236_().m_45976_(Mob.class, player.m_20191_().m_82400_(breakAngerConfig.range));
            if (!breakAngerConfig.block.matchesBlock(event.getState())) continue;
            entities.stream().filter(mob -> breakAngerConfig.entity.matchesEntity((Entity)mob)).filter(mob -> !breakAngerConfig.requiresLineOfSight || mob.m_142582_((Entity)player)).forEach(mob -> mob.m_6710_((LivingEntity)player));
        }
    }
}

