/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.climbing;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.climbing.ClimbClimbableGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs be able to climb ladders and similar blocks. Only entity types in `enhancedai:mobs/can_climb` tag are affected by this feature.")
public class Climbing
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_climb"));
    @Config(min=0.0, max=1.0)
    public static Double ladderClimbChance = 1.0;
    public static EAIData<Boolean> CAN_CLIMB_LADDERS_DATA;
    public static EAIData<Boolean> CAN_CLIMB_WALLS_DATA;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CAN_CLIMB_LADDERS_DATA = EAIData.ofBool(this.createDataKey("can_climb_ladders"), (mob, canClimb) -> {
            GoalHelper.removeGoal(mob.f_21345_, ClimbClimbableGoal.class);
            if (canClimb.booleanValue()) {
                mob.f_21345_.m_25352_(3, (Goal)new ClimbClimbableGoal((Mob)mob));
            }
        });
        CAN_CLIMB_WALLS_DATA = EAIData.ofBool(this.createDataKey("can_climb_walls"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        CAN_CLIMB_LADDERS_DATA.applyIfAbsent(mob, mob.m_217043_().m_188500_() < ladderClimbChance);
    }
}

