/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.flee;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.enhancedai.modules.mobs.flee.Flee;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.ModNBTData;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

@JsonAdapter(value=Serializer.class)
public class CustomFleeConfig {
    public int priority;
    public IdTagMatcher entity;
    public IdTagMatcher fleeFrom;
    public double chance;
    public double avoidDistance;
    public double avoidDistanceNear;
    public double speedMultiplier;
    public double speedMultiplierNear;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<CustomFleeConfig>>(){}.getType();

    public CustomFleeConfig(int priority, IdTagMatcher entity, IdTagMatcher fleeFrom, double chance, double avoidDistance, double avoidDistanceNear, double speedMultiplier, double speedMultiplierNear) {
        this.priority = priority;
        this.entity = entity;
        this.fleeFrom = fleeFrom;
        this.chance = chance;
        this.avoidDistance = avoidDistance;
        this.avoidDistanceNear = avoidDistanceNear;
        this.speedMultiplier = speedMultiplier;
        this.speedMultiplierNear = speedMultiplierNear;
    }

    public void tryApply(PathfinderMob mob) {
        ListTag customFleeListTag = ModNBTData.getList((Entity)mob, (ResourceLocation)Flee.CUSTOM_FLEE, (int)10);
        CompoundTag newTag = new CompoundTag();
        newTag.m_128405_("priority", this.priority);
        newTag.m_128359_("flee_from", this.fleeFrom.m_7912_());
        newTag.m_128347_("avoid_distance", this.avoidDistance);
        newTag.m_128347_("avoid_distance_near", this.avoidDistanceNear);
        newTag.m_128347_("speed_multiplier", this.speedMultiplier);
        newTag.m_128347_("speed_multiplier_near", this.speedMultiplierNear);
        customFleeListTag.add((Object)newTag);
        ModNBTData.put((Entity)mob, (ResourceLocation)Flee.CUSTOM_FLEE, (Object)customFleeListTag);
    }

    public static class Serializer
    implements JsonDeserializer<CustomFleeConfig>,
    JsonSerializer<CustomFleeConfig> {
        public CustomFleeConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            int priority = GsonHelper.m_13927_((JsonObject)jObject, (String)"priority");
            IdTagMatcher entity = (IdTagMatcher)context.deserialize(jObject.get("entity"), IdTagMatcher.class);
            IdTagMatcher fleeFrom = (IdTagMatcher)context.deserialize(jObject.get("flee_from"), IdTagMatcher.class);
            double chance = GsonHelper.m_144742_((JsonObject)jObject, (String)"chance", (double)1.0);
            double avoidDistance = GsonHelper.m_144784_((JsonObject)jObject, (String)"avoid_distance");
            double avoidDistanceNear = GsonHelper.m_144784_((JsonObject)jObject, (String)"avoid_distance_near");
            double speedMultiplier = GsonHelper.m_144784_((JsonObject)jObject, (String)"speed_multiplier");
            double speedMultiplierNear = GsonHelper.m_144784_((JsonObject)jObject, (String)"speed_multiplier_near");
            return new CustomFleeConfig(priority, entity, fleeFrom, chance, avoidDistance, avoidDistanceNear, speedMultiplier, speedMultiplierNear);
        }

        public JsonElement serialize(CustomFleeConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.addProperty("priority", (Number)src.priority);
            jObject.add("entity", context.serialize((Object)src.entity));
            jObject.add("flee_from", context.serialize((Object)src.fleeFrom));
            if (src.chance < 1.0) {
                jObject.addProperty("chance", (Number)src.chance);
            }
            jObject.addProperty("avoid_distance", (Number)src.avoidDistance);
            jObject.addProperty("avoid_distance_near", (Number)src.avoidDistanceNear);
            jObject.addProperty("speed_multiplier", (Number)src.speedMultiplier);
            jObject.addProperty("speed_multiplier_near", (Number)src.speedMultiplierNear);
            return jObject;
        }
    }
}

