/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.miner;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.data.EAIDataEnum;
import insane96mcp.enhancedai.data.EAIDataList;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.miner.MineTowardsTargetGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Mobs can mine blocks to reach the target. Uses offhand item to mine. Only mobs in the entity type tag enhancedai:mobs/can_mine can spawn with the ability to mine and blocks in the tag enhancedai:miner_blacklist cannot be mined. This feature also adds the block reach attribute to all entities.")
public class MinerMobs
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_MINER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/can_mine"));
    public static final TagKey<Block> BLOCK_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)EnhancedAI.location("miner_blacklist"));
    @Config(min=0.0, max=1.0, description="Chance for a mob in the entity type tag enhancedai:can_be_miner to spawn with the miner ability")
    public static Double minerChance = 0.07;
    @Config(description="NONE: No item is required. ANY_TOOL: Any item that can break blocks in the off-hand is required. CORRECT_TOOL_FOR_REQUIRED: The mob is able to mine any blocks that don't require a tool, and require a tool for blocks that require it (e.g. can always mine dirt but can't mine stone). CORRECT_TOOL_FOR_ANY_BLOCK: The mob can only mine blocks if the tool is the right one for the block (e.g. can mine dirt only with a shovel).")
    public static ToolRequirement toolRequirement = ToolRequirement.CORRECT_TOOL_FOR_REQUIRED;
    @Config(min=-512.0, max=1024.0, description="Mobs can mine from the bottom of the world to this Y level.")
    public static Integer maxY = 320;
    @Config(min=0.0, max=128.0, description="The maximum distance from the target at which the Mobs can mine. Set to 0 to always mine.")
    public static Integer maxTargetDistance = 0;
    @Config(min=0.0, max=128.0, description="Multiplier for the time a mob takes to break blocks. E.g. with this set to 2, mobs will take twice the time to mine a block.")
    public static Double timeToBreakMultiplier = 1.25;
    @Config(description="Dimensions where mobs can mine.")
    public static List<String> dimensionWhitelist = List.of("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end");
    @Config(description="If true, the block tag `enhancedai:miner_mobs/blacklist` will be treated as a whitelist instead of blacklist")
    public static Boolean blockBlacklistAsWhitelist = false;
    @Config(description="Mobs with Miner AI will not be able to break tile entities")
    public static Boolean blacklistTileEntities = true;
    @Config(description="Mobs with Miner AI will spawn with a Stone Pickaxe that never drops.")
    public static Boolean equipStonePick = true;
    public static EAIData<Boolean> MINER;
    public static EAIDataEnum<ToolRequirement> TOOL_REQUIREMENT;
    public static EAIData<Integer> MAX_Y;
    public static EAIData<Integer> MAX_TARGET_DISTANCE;
    public static EAIData<Double> TIME_TO_BREAK_MULTIPLIER;
    public static EAIDataList<String> DIMENSION_WHITELIST;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        MINER = EAIData.ofBool(this.createDataKey("miner"), (mob, miner) -> {
            GoalHelper.removeGoal(mob.f_21345_, MineTowardsTargetGoal.class);
            if (miner.booleanValue()) {
                mob.f_21345_.m_25352_(1, (Goal)new MineTowardsTargetGoal((Mob)mob));
            }
        });
        TOOL_REQUIREMENT = EAIDataEnum.of(this.createDataKey("tool_requirement"), ToolRequirement.class);
        MAX_Y = EAIData.ofInt(this.createDataKey("max_y"));
        MAX_TARGET_DISTANCE = EAIData.ofInt(this.createDataKey("max_target_distance"));
        TIME_TO_BREAK_MULTIPLIER = EAIData.ofDouble(this.createDataKey("time_to_break_multiplier"));
        DIMENSION_WHITELIST = EAIDataList.of(this.createDataKey("dimension_whitelist"), String.class);
    }

    public static void addAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)ForgeMod.BLOCK_REACH.get())) continue;
            event.add(entityType, (Attribute)ForgeMod.BLOCK_REACH.get());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_BE_MINER)) {
            return;
        }
        boolean isMiner = mob.m_217043_().m_188500_() < minerChance;
        MINER.applyIfAbsent(mob, isMiner);
        if (isMiner && equipStonePick.booleanValue() && mob.m_21206_().m_41619_()) {
            mob.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42427_));
            mob.m_21409_(EquipmentSlot.OFFHAND, -1.0f);
        }
        TOOL_REQUIREMENT.applyIfAbsent(mob, toolRequirement);
        MAX_Y.applyIfAbsent(mob, maxY);
        MAX_TARGET_DISTANCE.applyIfAbsent(mob, maxTargetDistance);
        TIME_TO_BREAK_MULTIPLIER.applyIfAbsent(mob, timeToBreakMultiplier);
        DIMENSION_WHITELIST.applyIfAbsent(mob, (String)((Object)dimensionWhitelist));
    }

    public static boolean isValidDimension(Mob mob) {
        Object dimensionWhitelist = DIMENSION_WHITELIST.get((Entity)mob);
        Iterator iterator = dimensionWhitelist.iterator();
        while (iterator.hasNext()) {
            String dimension = (String)iterator.next();
            if (!dimension.equals(mob.m_9236_().m_46472_().m_135782_().toString())) continue;
            return true;
        }
        return false;
    }

    public static enum ToolRequirement {
        NONE,
        ANY_TOOL,
        CORRECT_TOOL_FOR_REQUIRED,
        CORRECT_TOOL_FOR_ANY_BLOCK;

    }
}

