/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.targeting;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAIHurtByTargetGoal;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.targeting.EAINearestAttackableTarget;
import insane96mcp.enhancedai.modules.mobs.targeting.EAIShulkerNearestAttackTargetGoal;
import insane96mcp.enhancedai.modules.mobs.targeting.EAIShulkerNearestDefenseTargetGoal;
import insane96mcp.enhancedai.modules.mobs.targeting.EAISpiderTargetGoal;
import insane96mcp.enhancedai.modules.mobs.targeting.EAIVindicatorJohnnyTargetGoal;
import insane96mcp.enhancedai.setup.EAIAttributes;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Change how mobs target players. Check the config options below for entity type tags.")
public class Targeting
extends JsonFeature {
    public static final TagKey<EntityType<?>> CHANGE_FOLLOW_RANGE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/targeting/follow_range_override"));
    public static final TagKey<EntityType<?>> BETTER_HURT_BY = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/targeting/better_hurt_by"));
    public static final TagKey<EntityType<?>> BETTER_NEARBY_TARGETING = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/targeting/better_nearby_targeting"));
    public static final TagKey<EntityType<?>> ALLOW_TARGET_SWITCH = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/targeting/allow_target_switch"));
    public static final TagKey<EntityType<?>> APPLY_XRAY = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/targeting/apply_xray"));
    public static final TagKey<EntityType<?>> VISITED_NODES_MULTIPLIER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/targeting/visited_nodes_multiplier"));
    public static final TagKey<EntityType<?>> ALERT_NEARBY = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/targeting/alert_nearby"));
    @Config(min=0.0, max=128.0, description="How far away can the mobs see the player. This overrides the vanilla value (16 for most mobs). Setting 'Max' to 0 will leave the follow range as vanilla. Use mods like Mobs Properties Randomness to have more control over the attribute. Only mobs in the entity type tag `enhancedai:mobs/targeting/follow_range_override` will be affected by this override")
    public static MinMax followRangeOverride = new MinMax(32.0, 48.0);
    @Config(min=0.0, max=128.0, description="How far away can the mobs see the player even through walls. This only works with 'Better Nearby Targeting' enabled. Setting 'Max' to 0 will make mobs not able to see through walls. Use mods like Mobs Properties Randomness to have more control over the attribute; the attribute name is 'enhancedai:xray_follow_range'. Only mobs in the entity type tag `enhancedai:mobs/targeting/apply_xray` will be affected by this override.")
    public static MinMax xrayRangeOverride = new MinMax(16.0, 24.0);
    @Config(min=0.0, max=1.0, description="Chance for a mob the get the xray range override.")
    public static Double xrayRangeOverrideChance = 0.5;
    @Config
    public static Boolean seeGlowingEntities = true;
    @Config(description="Mobs will actually switch target when attacked unless it's the same or if the current one it's closer. Only entity types in the entity type tag `enhancedai:mobs/targeting/better_hurt_by` tag will be affected by this. Use the entity type tag `enhancedai:mobs/targeting/allow_target_switch` to allow more entity types to switch targets (e.g. creepers in vanilla can't switch targets).")
    public static Boolean betterHurtByTarget$enable = true;
    @Config(description="Setting this to true allows overriding target AI only for players.")
    public static Boolean betterHurtByTarget$playerOnly = false;
    @Config(description="Mobs will prefer to attack players instead of other mobs (Note that 'Prevent infighting' should be disabled).")
    public static Boolean betterHurtByTarget$preferPlayers = false;
    @Config(min=0.0, max=1.0, description="Change for a mob to not attack other mobs when hit.")
    public static Double betterHurtByTarget$preventInfighting = 0.9;
    @Config(min=0.0, description="Mobs in the entity type tag `enhancedai:mobs/targeting/alert_nearby` will alert nearby mobs in this range and target the player.")
    public static Integer alertRange = 32;
    @Config(description="Mobs NearestAttackableTargetGoal will be replaced with mod's one for better configuration and targeting.")
    public static Boolean betterNearbyTargeting$enable = true;
    @Config(description="1 in x chance every other tick for a mob to target a nearby entity. Vanilla is 10. Setting to 0 will make the mob instantly target entities. The higher the more time will take mobs to target entities.")
    public static Integer betterHurtByTarget$targetChance = 7;
    @Config(min=0.0, max=1.0, description="Chances for a mob to spawn neutral (so will not attack players until provoked)")
    public static Difficulty betterNearbyTargeting$neutralChances = new Difficulty(0.25, 0.1, 0.04);
    @Config(description="Mobs will be able to find better and longer paths to the target the higher this value is. The higher the more performance heavy. Only entity types in the tag `enhancedai:mobs/targeting/visited_nodes_multiplier` tag will be affected by this. Vanilla is 1.0")
    public static Double maxVisitedNodesMultiplier = 4.0;
    public static ResourceLocation FOLLOW_RANGES_PROCESSED;
    public static ResourceLocation NEUTRAL;
    public static EAIData<Double> MAX_VISITED_NODES_MULTIPLIER;
    public static EAIData<Boolean> HURT_BY_PREFER_PLAYERS;
    public static EAIData<Boolean> HURT_BY_PREVENT_INFIGHTING;
    public static EAIData<Integer> TARGET_CHANCE;
    public static EAIData<Integer> UNSEEN_FORGET_TICKS;
    public static EAIData<Integer> ALERT_RANGE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        FOLLOW_RANGES_PROCESSED = this.createDataKey("follow_ranges_processed");
        NEUTRAL = this.createDataKey("neutral");
        MAX_VISITED_NODES_MULTIPLIER = EAIData.ofDouble(this.createDataKey("max_visited_nodes_multiplier"), (mob, multiplier) -> mob.m_21573_().m_26529_(multiplier.floatValue()));
        HURT_BY_PREFER_PLAYERS = EAIData.ofBool(this.createDataKey("hurt_by_prefer_players"));
        HURT_BY_PREVENT_INFIGHTING = EAIData.ofBool(this.createDataKey("hurt_by_prevent_infighting"), (mob, preventInfighting) -> GoalHelper.getGoal(mob.f_21346_, EAIHurtByTargetGoal.class).ifPresent(goal -> {
            if (preventInfighting.booleanValue()) {
                goal.preventInfighting();
            } else {
                goal.allowInfighting();
            }
        }));
        TARGET_CHANCE = EAIData.ofInt(this.createDataKey("target_chance"));
        UNSEEN_FORGET_TICKS = EAIData.ofInt(this.createDataKey("unseen_forget_ticks"));
        ALERT_RANGE = EAIData.ofInt(this.createDataKey("alert_range"));
    }

    public String getModConfigFolder() {
        return "config/enhancedai";
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)EAIAttributes.XRAY_FOLLOW_RANGE.get())) continue;
            event.add(entityType, (Attribute)EAIAttributes.XRAY_FOLLOW_RANGE.get(), 0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        this.processFollowRanges(mob);
        this.processTargetGoal(mob);
        this.processHurtByGoal(mob);
        this.processMaxTargetingNodes(mob);
        ALERT_RANGE.applyIfAbsent(mob, alertRange);
    }

    private void processFollowRanges(Mob mob) {
        if (!((Boolean)ModNBTData.get((Entity)mob, (ResourceLocation)FOLLOW_RANGES_PROCESSED, Boolean.class)).booleanValue()) {
            if (mob.m_6095_().m_204039_(CHANGE_FOLLOW_RANGE) && Targeting.followRangeOverride.max != 0.0 && mob.m_21051_(Attributes.f_22277_) != null) {
                MCUtils.setAttributeValue((LivingEntity)mob, (Attribute)Attributes.f_22277_, (double)followRangeOverride.getIntRandBetween(mob.m_217043_()));
            }
            if (mob.m_6095_().m_204039_(APPLY_XRAY) && mob.m_21051_((Attribute)EAIAttributes.XRAY_FOLLOW_RANGE.get()) != null && (double)mob.m_217043_().m_188501_() < xrayRangeOverrideChance) {
                MCUtils.setAttributeValue((LivingEntity)mob, (Attribute)((Attribute)EAIAttributes.XRAY_FOLLOW_RANGE.get()), (double)xrayRangeOverride.getIntRandBetween(mob.m_217043_()));
            }
        }
        ModNBTData.put((Entity)mob, (ResourceLocation)FOLLOW_RANGES_PROCESSED, (Object)true);
    }

    private void processTargetGoal(Mob mob) {
        if (!betterNearbyTargeting$enable.booleanValue() || !mob.m_6095_().m_204039_(BETTER_NEARBY_TARGETING)) {
            return;
        }
        ArrayList<NearestAttackableTargetGoal> toRemove = new ArrayList<NearestAttackableTargetGoal>();
        ArrayList<WrappedGoal> toAdd = new ArrayList<WrappedGoal>();
        for (WrappedGoal prioritizedGoal : mob.f_21346_.f_25345_) {
            Goal goal = prioritizedGoal.m_26015_();
            if (!(goal instanceof NearestAttackableTargetGoal)) continue;
            NearestAttackableTargetGoal goal2 = (NearestAttackableTargetGoal)goal;
            if (goal2.f_26048_ != Player.class && betterHurtByTarget$playerOnly.booleanValue()) continue;
            toRemove.add(goal2);
            boolean neutral = NBTUtils.getBooleanOrPutDefault((Entity)mob, NEUTRAL, mob.m_217043_().m_188500_() < betterNearbyTargeting$neutralChances.getByDifficulty(mob.m_9236_()));
            if (neutral && goal2.f_26048_ == Player.class) continue;
            EAINearestAttackableTarget<? extends LivingEntity> newTargetGoal = Targeting.createTargetGoal(mob, goal2);
            toAdd.add(new WrappedGoal(prioritizedGoal.m_26012_(), newTargetGoal));
        }
        toRemove.forEach(arg_0 -> ((GoalSelector)mob.f_21346_).m_25363_(arg_0));
        toAdd.forEach(wrappedGoal -> mob.f_21346_.m_25352_(wrappedGoal.m_26012_(), wrappedGoal.m_26015_()));
        TARGET_CHANCE.applyIfAbsent(mob, betterHurtByTarget$targetChance);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static EAINearestAttackableTarget<? extends LivingEntity> createTargetGoal(Mob mob, NearestAttackableTargetGoal<?> goal) {
        void var2_7;
        EAINearestAttackableTarget eAINearestAttackableTarget = new EAINearestAttackableTarget(mob, goal.f_26048_, false, true, goal.f_26051_);
        if (mob instanceof Spider) {
            Spider spider = (Spider)mob;
            EAISpiderTargetGoal eAISpiderTargetGoal = new EAISpiderTargetGoal(spider, goal.f_26048_, false, true, goal.f_26051_);
            return var2_7;
        }
        if (mob instanceof Vindicator) {
            Vindicator vindicator = (Vindicator)mob;
            if (goal instanceof Vindicator.VindicatorJohnnyAttackGoal) {
                EAIVindicatorJohnnyTargetGoal eAIVindicatorJohnnyTargetGoal = new EAIVindicatorJohnnyTargetGoal(vindicator, false, true, goal.f_26051_);
                return var2_7;
            }
        }
        if (!(mob instanceof Shulker)) return var2_7;
        Shulker shulker = (Shulker)mob;
        if (goal instanceof Shulker.ShulkerNearestAttackGoal) {
            EAIShulkerNearestAttackTargetGoal eAIShulkerNearestAttackTargetGoal = new EAIShulkerNearestAttackTargetGoal(shulker, goal.f_26048_, false, true, goal.f_26051_);
            return var2_7;
        }
        if (!(goal instanceof Shulker.ShulkerDefenseAttackGoal)) return var2_7;
        EAIShulkerNearestDefenseTargetGoal eAIShulkerNearestDefenseTargetGoal = new EAIShulkerNearestDefenseTargetGoal(shulker, goal.f_26048_, false, true, goal.f_26051_);
        return var2_7;
    }

    private void processHurtByGoal(Mob mob) {
        if (!betterHurtByTarget$enable.booleanValue() || !mob.m_6095_().m_204039_(BETTER_HURT_BY)) {
            return;
        }
        ArrayList<HurtByTargetGoal> toRemove = new ArrayList<HurtByTargetGoal>();
        ArrayList<WrappedGoal> toAdd = new ArrayList<WrappedGoal>();
        for (WrappedGoal prioritizedGoal : mob.f_21346_.f_25345_) {
            Goal goal = prioritizedGoal.m_26015_();
            if (!(goal instanceof HurtByTargetGoal)) continue;
            HurtByTargetGoal goal2 = (HurtByTargetGoal)goal;
            toRemove.add(goal2);
            ArrayList<Class> toIgnoreDamage = new ArrayList<Class>(Arrays.asList(goal2.f_26035_));
            EAIHurtByTargetGoal newGoal = new EAIHurtByTargetGoal(mob, (Class[])toIgnoreDamage.toArray(Class[]::new));
            if (goal2.f_26036_ != null) {
                newGoal.setAlertOthers(goal2.f_26036_);
            }
            toAdd.add(new WrappedGoal(prioritizedGoal.m_26012_(), (Goal)newGoal));
        }
        toAdd.forEach(wrappedGoal -> mob.f_21346_.m_25352_(wrappedGoal.m_26012_(), wrappedGoal.m_26015_()));
        if (!toRemove.isEmpty()) {
            toRemove.forEach(arg_0 -> ((GoalSelector)mob.f_21346_).m_25363_(arg_0));
        } else if (mob.m_6095_().m_204039_(ALLOW_TARGET_SWITCH)) {
            EAIHurtByTargetGoal newGoal = new EAIHurtByTargetGoal(mob, new Class[0]);
            mob.f_21346_.m_25352_(1, (Goal)newGoal);
        }
        HURT_BY_PREFER_PLAYERS.applyIfAbsent(mob, betterHurtByTarget$preferPlayers);
        HURT_BY_PREVENT_INFIGHTING.applyIfAbsent(mob, (double)mob.m_217043_().m_188501_() < betterHurtByTarget$preventInfighting);
    }

    private void processMaxTargetingNodes(Mob mob) {
        if (!mob.m_6095_().m_204039_(VISITED_NODES_MULTIPLIER)) {
            return;
        }
        MAX_VISITED_NODES_MULTIPLIER.applyIfAbsent(mob, maxVisitedNodesMultiplier);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        ServerPlayer attacker;
        Mob mob;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || alertRange <= 0 || !((livingEntity = event.getEntity()) instanceof Mob) || !(mob = (Mob)livingEntity).m_6095_().m_204039_(ALERT_NEARBY) || !((livingEntity = event.getSource().m_7639_()) instanceof ServerPlayer)) break block2;
                attacker = (ServerPlayer)livingEntity;
                if (attacker.f_8941_.m_9294_()) break block3;
            }
            return;
        }
        event.getEntity().m_9236_().m_6249_((Entity)mob, mob.m_20191_().m_82400_((double)ALERT_RANGE.get((Entity)mob).intValue()), entity -> entity.m_6095_() == mob.m_6095_()).forEach(entity -> {
            if (!(entity instanceof Mob)) {
                return;
            }
            Mob nearbyMob = (Mob)entity;
            if (nearbyMob.m_5448_() != null && nearbyMob.m_20280_((Entity)nearbyMob.m_5448_()) <= nearbyMob.m_20280_((Entity)attacker)) {
                return;
            }
            nearbyMob.m_6710_((LivingEntity)attacker);
        });
    }
}

