/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.teleporttotarget;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.mobs.teleporttotarget.TeleportToTargetGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs teleport other mobs close to the target. Mobs in the `enhancedai:mobs/teleport_to_target/can_be_teleported` tag will be able to be picked up, while mobs in the `enhancedai:mobs/teleport_to_target/can_teleport` tag will be able to pick up other mobs.")
public class TeleportToTarget
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_TELEPORTED = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/teleport_to_target/can_be_teleported"));
    public static final TagKey<EntityType<?>> CAN_TELEPORT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("mobs/teleport_to_target/can_teleport"));
    @Config(min=0.0, max=1.0, description="Chance for a mob to have an AI to go and pick up and throw mobs.")
    public static Difficulty chance = new Difficulty(0.35, 0.35, 0.5);
    @Config(min=0.0, description="Cooldown (in ticks) after throwing a mob. Also goes on cooldown if can't reach the targeted mob for a few seconds")
    public static Integer cooldown = 600;
    public static EAIData<String> CAN_TELEPORT_DATA;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CAN_TELEPORT_DATA = EAIData.ofString(this.createDataKey("can_teleport"));
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_TELEPORT) || mob.m_6162_()) {
            return;
        }
        if (mob.m_217043_().m_188500_() < chance.getByDifficulty(mob.m_9236_())) {
            CAN_TELEPORT_DATA.applyIfAbsent(mob, CAN_BE_TELEPORTED.f_203868_().toString());
        } else {
            CAN_TELEPORT_DATA.applyIfAbsent(mob, "");
        }
        mob.f_21346_.m_25352_(0, (Goal)new TeleportToTargetGoal(mob));
    }
}

