/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.shulker;

import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:shulker", description="Shulker bullets' levitation duration and amplifier based off owner's data")
public class ShulkerBullets
extends Feature {
    @Config(min=1.0, max=600.0)
    public static Difficulty levitationDuration = new Difficulty(100.0, 100.0, 160.0);
    @Config(min=0.0, max=127.0, description="Note that 0 = I, 1 = II, and so on")
    public static Difficulty levitationAmplifier = new Difficulty(5.0, 5.0, 5.0);
    public static EAIData<Integer> LEVITATION_DURATION;
    public static EAIData<Integer> LEVITATION_AMPLIFIER;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        LEVITATION_DURATION = EAIData.ofInt(this.createDataKey("levitation_duration"));
        LEVITATION_AMPLIFIER = EAIData.ofInt(this.createDataKey("levitation_amplifier"));
    }

    public static MobEffectInstance getLevitationInstance(Level level, MobEffectInstance originalValue, @Nullable Entity owner) {
        if (!ShulkerBullets.isEnabled(ShulkerBullets.class)) {
            return originalValue;
        }
        if (!(owner instanceof Mob)) {
            return new MobEffectInstance(MobEffects.f_19620_, (int)levitationDuration.getByDifficulty(level), (int)levitationAmplifier.getByDifficulty(level));
        }
        Mob mob = (Mob)owner;
        return new MobEffectInstance(MobEffects.f_19620_, LEVITATION_DURATION.get((Entity)mob).intValue(), LEVITATION_AMPLIFIER.get((Entity)mob).intValue());
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)entity;
        LEVITATION_DURATION.applyIfAbsent((Mob)shulker, (int)levitationDuration.getByDifficulty(event.getLevel()));
        LEVITATION_AMPLIFIER.applyIfAbsent((Mob)shulker, (int)levitationAmplifier.getByDifficulty(event.getLevel()));
    }
}

