/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.shulker.shulkerattack;

import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.shulker.shulkerattack.EAIShulkerAttackGoal;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:shulker")
public class ShulkerAttack
extends Feature {
    @Config(min=0.0, description="Ticks before the first bullet is fired")
    public static MinMax baseAttackSpeed = new MinMax(20.0, 40.0);
    @Config(min=1.0, description="Ticks to fire is calculated as base_attack_speed + (0~extra_attack_speed)")
    public static MinMax extraAttackSpeed = new MinMax(100.0, 200.0);
    public static EAIData<Integer> BASE_ATTACK_SPEED;
    public static EAIData<Integer> EXTRA_ATTACK_SPEED;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        BASE_ATTACK_SPEED = EAIData.ofInt(this.createDataKey("base_attack_speed"));
        EXTRA_ATTACK_SPEED = EAIData.ofInt(this.createDataKey("extra_attack_speed"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)entity;
        GoalHelper.removeGoal(shulker.f_21345_, Shulker.ShulkerAttackGoal.class);
        EAIShulkerAttackGoal attackGoal = new EAIShulkerAttackGoal(shulker);
        shulker.f_21345_.m_25352_(2, (Goal)attackGoal);
        BASE_ATTACK_SPEED.applyIfAbsent((Mob)shulker, baseAttackSpeed.getIntRandBetween(shulker.m_217043_()));
        EXTRA_ATTACK_SPEED.applyIfAbsent((Mob)shulker, extraAttackSpeed.getIntRandBetween(shulker.m_217043_()));
    }
}

