/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAIAvoidTargetGoal;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.enhancedai.modules.skeleton.shoot.EAIRangedBowAttackGoal;
import insane96mcp.enhancedai.modules.skeleton.shoot.SkeletonShoot;
import insane96mcp.enhancedai.utils.GoalHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;

@LoadFeature(module="enhancedai:skeleton", description="Skeletons try to stay away from the target. Only entity types in `enhancedai:skeleton/can_flee` tag are affected by this feature. This disables itself if Skeleton Shoot feature is disabled")
public class SkeletonFleeTarget
extends Feature {
    public static final TagKey<EntityType<?>> CAN_FLEE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("skeleton/can_flee"));
    @Config(min=0.0, max=1.0, description="Chance for a Skeleton to spawn with the ability to avoid the target")
    public static Double avoidTargetChance = 0.5;
    @Config(min=0.0, max=1.0, description="Chance for a Skeleton to be able to shoot while running from the target")
    public static Double attackWhenAvoidingChance = 0.5;
    @Config(min=0.0, max=32.0, description="Distance from a target that will make the skeleton run away.")
    public static Integer fleeDistanceFar = 16;
    @Config(min=0.0, max=32.0, description="Distance from a target that counts as near and will make the skeleton run away faster.")
    public static Integer fleeDistanceNear = 8;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the skeleton avoids the target and it's farther than 'Flee Distance Far' blocks from him.")
    public static Double fleeSpeedFar = 1.1;
    @Config(min=0.0, max=4.0, description="Speed multiplier when the skeleton avoids the target and it's within 'Flee Distance Near' blocks from him.")
    public static Double fleeSpeedNear = 1.25;
    public static EAIData<Boolean> AVOID_TARGET;
    public static EAIData<Boolean> ATTACK_WHEN_AVOIDING;
    public static EAIData<Integer> FLEE_DISTANCE_FAR;
    public static EAIData<Integer> FLEE_DISTANCE_NEAR;
    public static EAIData<Double> FLEE_SPEED_FAR;
    public static EAIData<Double> FLEE_SPEED_NEAR;

    public boolean isEnabled() {
        return super.isEnabled() && Feature.isEnabled(SkeletonShoot.class);
    }

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        AVOID_TARGET = EAIData.ofBool(this.createDataKey("avoid_target"), (mob, avoidTarget) -> {
            if (!(mob instanceof AbstractSkeleton)) {
                return;
            }
            AbstractSkeleton skeleton = (AbstractSkeleton)mob;
            GoalHelper.removeGoal(skeleton.f_21345_, EAIAvoidTargetGoal.class);
            if (avoidTarget.booleanValue() && (GoalHelper.hasGoal(skeleton.f_21345_, (Goal)skeleton.f_32130_) || GoalHelper.hasGoal(skeleton.f_21345_, EAIRangedBowAttackGoal.class))) {
                skeleton.f_21345_.m_25352_(1, (Goal)new EAIAvoidTargetGoal((PathfinderMob)skeleton, FLEE_DISTANCE_FAR, FLEE_DISTANCE_NEAR, FLEE_SPEED_FAR, FLEE_SPEED_NEAR));
            }
            ATTACK_WHEN_AVOIDING.changed((Mob)mob);
        });
        ATTACK_WHEN_AVOIDING = EAIData.ofBool(this.createDataKey("attack_when_avoiding"), (mob, attackWhenAvoiding) -> GoalHelper.getGoal(mob.f_21345_, EAIAvoidTargetGoal.class).ifPresent(goal -> goal.setAttackWhenRunning((boolean)attackWhenAvoiding)));
        FLEE_DISTANCE_FAR = EAIData.ofInt(this.createDataKey("flee_distance_far"));
        FLEE_DISTANCE_NEAR = EAIData.ofInt(this.createDataKey("flee_distance_near"));
        FLEE_SPEED_FAR = EAIData.ofDouble(this.createDataKey("flee_speed_far"));
        FLEE_SPEED_NEAR = EAIData.ofDouble(this.createDataKey("flee_speed_near"));
    }

    public static void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!SkeletonFleeTarget.isEnabled(SkeletonFleeTarget.class) || Spawning.isUnaffectedByFeatures((Entity)skeleton) || !skeleton.m_6095_().m_204039_(CAN_FLEE)) {
            return;
        }
        AVOID_TARGET.applyIfAbsent((Mob)skeleton, skeleton.m_217043_().m_188500_() < avoidTargetChance);
        ATTACK_WHEN_AVOIDING.applyIfAbsent((Mob)skeleton, skeleton.m_217043_().m_188500_() < attackWhenAvoidingChance);
        FLEE_DISTANCE_FAR.applyIfAbsent((Mob)skeleton, fleeDistanceFar);
        FLEE_DISTANCE_NEAR.applyIfAbsent((Mob)skeleton, fleeDistanceNear);
        FLEE_SPEED_FAR.applyIfAbsent((Mob)skeleton, fleeSpeedFar);
        FLEE_SPEED_NEAR.applyIfAbsent((Mob)skeleton, fleeSpeedNear);
    }
}

