/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.data.EAIData;
import insane96mcp.enhancedai.data.PotionOrMobEffect;
import insane96mcp.enhancedai.modules.mobs.Spawning;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@LoadFeature(module="enhancedai:witch", description="Witches drink more potions.")
public class ThirstyWitches
extends Feature {
    public static final TagKey<EntityType<?>> AFFECTED_ENTITY_TYPES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("witch/thirsty"));
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> drinkPotionConfig;
    public static final List<String> drinkPotionDefault;
    public static ArrayList<PotionOrMobEffect> drinkPotion;
    @Config(min=0.0, description="When witches are this many blocks away from the player will be able to drink the potions in 'Drinkable potions if targeting player'")
    public static Double customDrinkDistanceSafe;
    @Config(min=0.0, max=1.0, description="Chance for a witch to drink a healing potion when not full health. Defaults to Vanilla")
    public static Double healingChance;
    @Config(min=0.0, max=1.0, description="Below this percentage health, witches will try to drink healing potions.")
    public static Double healingThreshold;
    @Config(min=0.0, max=1.0, description="Below this percentage health, witches will drink strong healing potions instead of normal ones.")
    public static Double strongHealingThreshold;
    @Config(min=0.0, max=1.0, description="Chance each tick for a witch to drink a water breathing potion when in water and air meter is at half. Vanilla is 15% and doesn't check the air meter.")
    public static Double waterBreathingChance;
    @Config(min=0.0, max=1.0, description="Chance each tick for a witch to drink a fire resistance potion when on fire. Vanilla is 15%.")
    public static Double fireResistanceChance;
    @Config(min=0.0, max=1.0, description="Chance each tick for a witch to drink milk when they have a negative effect.")
    public static Double milkChance;
    @Config
    public static Boolean playSoundWhenDrinking;
    public static EAIData<Double> CUSTOM_DRINK_DISTANCE_SAFE;
    public static EAIData<Double> HEALING_CHANCE;
    public static EAIData<Double> HEALING_THRESHOLD;
    public static EAIData<Double> STRONG_HEALING_THRESHOLD;
    public static EAIData<Double> WATER_BREATHING_CHANCE;
    public static EAIData<Double> FIRE_RESISTANCE_CHANCE;
    public static EAIData<Double> MILK_CHANCE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        CUSTOM_DRINK_DISTANCE_SAFE = EAIData.ofDouble(this.createDataKey("custom_drink_distance_safe"));
        HEALING_CHANCE = EAIData.ofDouble(this.createDataKey("healing_chance"));
        HEALING_THRESHOLD = EAIData.ofDouble(this.createDataKey("healing_threshold"));
        STRONG_HEALING_THRESHOLD = EAIData.ofDouble(this.createDataKey("strong_healing_threshold"));
        WATER_BREATHING_CHANCE = EAIData.ofDouble(this.createDataKey("water_breathing_chance"));
        FIRE_RESISTANCE_CHANCE = EAIData.ofDouble(this.createDataKey("fire_resistance_chance"));
        MILK_CHANCE = EAIData.ofDouble(this.createDataKey("milk_chance"));
    }

    public void loadConfigOptions() {
        super.loadConfigOptions();
        drinkPotionConfig = this.getBuilder().comment("A list of potions that the witch will drink when a player is targeted and it's at least 6 blocks away. Format is potion_id or effect_id,duration,amplifier. The potions are applied in order and witches will not drink the same potion if already has the effect.").defineList("Drinkable potions if targeting player", drinkPotionDefault, o -> o instanceof String);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        drinkPotion = PotionOrMobEffect.parseList((List)drinkPotionConfig.get());
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Witch witch;
        Entity entity;
        if (!this.isEnabled() || Spawning.isUnaffectedByFeatures(event.getEntity()) || !((entity = event.getEntity()) instanceof Witch) || !(witch = (Witch)entity).m_6095_().m_204039_(AFFECTED_ENTITY_TYPES)) {
            return;
        }
        CUSTOM_DRINK_DISTANCE_SAFE.applyIfAbsent((Mob)witch, customDrinkDistanceSafe);
        HEALING_CHANCE.applyIfAbsent((Mob)witch, healingChance);
        HEALING_THRESHOLD.applyIfAbsent((Mob)witch, healingThreshold);
        STRONG_HEALING_THRESHOLD.applyIfAbsent((Mob)witch, strongHealingThreshold);
        WATER_BREATHING_CHANCE.applyIfAbsent((Mob)witch, waterBreathingChance);
        FIRE_RESISTANCE_CHANCE.applyIfAbsent((Mob)witch, fireResistanceChance);
        MILK_CHANCE.applyIfAbsent((Mob)witch, milkChance);
    }

    static {
        drinkPotionDefault = List.of("minecraft:strong_swiftness", "minecraft:regeneration");
        customDrinkDistanceSafe = 6.0;
        healingChance = 0.05;
        healingThreshold = 0.7;
        strongHealingThreshold = 0.35;
        waterBreathingChance = 1.0;
        fireResistanceChance = 1.0;
        milkChance = 0.1;
        playSoundWhenDrinking = true;
    }
}

